/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.action_hunger.mixin;

import com.minenash.action_hunger.ActionHunger;
import com.minenash.action_hunger.config.Config;
import net.minecraft.class_1267;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1819;
import net.minecraft.class_1928;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_1702.class})
public abstract class HungerManagerMixin {
    @Shadow
    private int field_7756;
    @Shadow
    private float field_7752;
    @Shadow
    private float field_7753;
    @Shadow
    private int field_7755;
    @Unique
    private int constantRegenTimer = 0;
    @Unique
    private int constantHungerTimer = 0;
    @Unique
    private int shieldExhaustionTimer = 0;

    @Shadow
    public abstract void method_7583(float var1);

    @Shadow
    private void method_59684(int food, float exhaustion) {
    }

    @Redirect(method={"eat"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;addInternal(IF)V"))
    private void actionHunger$modifyFoodComponent(class_1702 manager, int food, float saturation) {
        this.method_59684(Math.round((float)food * Config.hungerFromFoodMultiplier), saturation * Config.saturationFromFoodMultiplier);
    }

    @Overwrite
    public void method_7588(class_1657 player) {
        boolean blockRegenFromShield;
        boolean isPlayerUsingShield;
        class_1267 difficulty = player.method_37908().method_8407();
        if (this.field_7752 > 4.0f) {
            this.field_7752 -= 4.0f;
            if (this.field_7753 > 0.0f) {
                this.field_7753 = Math.max(this.field_7753 - 1.0f, 0.0f);
            } else if (difficulty != class_1267.field_5801) {
                this.field_7756 = Math.max(this.field_7756 - 1, 0);
            }
        }
        if (player.method_31549().field_7480) {
            return;
        }
        double dynamicRegenRateModifier = ActionHunger.getCurveModifier(player.method_6032(), Config.dynamicRegenRateCurve, Config.dynamicRegenRateMultiplier);
        boolean regened = false;
        boolean bl = isPlayerUsingShield = player.method_6030().method_7909() instanceof class_1819 || class_7923.field_41178.method_10221((Object)player.method_6030().method_7909()).method_12832().contains("shield") || class_7923.field_41178.method_10221((Object)player.method_6030().method_7909()).method_12832().contains("buckler");
        if (isPlayerUsingShield) {
            ++this.shieldExhaustionTimer;
            if (this.shieldExhaustionTimer >= Config.shieldExhaustionRate) {
                this.exhaustion("Shield", Config.shieldExhaustionAmount);
            }
        } else {
            this.shieldExhaustionTimer = 0;
        }
        boolean bl2 = blockRegenFromShield = Config.disableRegenWhenUsingShield && isPlayerUsingShield;
        if (player.method_37908().method_8450().method_8355(class_1928.field_19395) && !blockRegenFromShield) {
            regened = this.regen(player, dynamicRegenRateModifier);
        }
        ++this.constantHungerTimer;
        double d = this.constantHungerTimer;
        double d2 = Config.constantExhaustionRate;
        double d3 = Config.dynamicRegenOnConstantExhaustion ? dynamicRegenRateModifier : 1.0;
        if (d >= d2 * d3) {
            this.exhaustion("Const", Config.constantExhaustionAmount);
            this.constantHungerTimer = 0;
        }
        if (this.field_7756 <= 0) {
            ++this.field_7755;
            if (this.field_7755 >= Config.starvationDamageRate) {
                if (player.method_6032() > 10.0f || difficulty == class_1267.field_5807 || player.method_6032() > 1.0f && difficulty == class_1267.field_5802) {
                    player.method_5643(player.method_48923().method_48825(), Config.starvationDamageAmount);
                }
                this.field_7755 = 0;
            }
        } else if (!regened) {
            this.field_7755 = 0;
        }
    }

    private boolean regen(class_1657 player, double dynamicRegenRateModifier) {
        ++this.constantRegenTimer;
        double d = this.constantRegenTimer;
        double d2 = Config.constantRegenRate;
        double d3 = Config.dynamicRegenOnConstantRegen ? dynamicRegenRateModifier : 1.0;
        if (d >= d2 * d3) {
            this.heal(player, "Const", Config.constantRegenAmount);
            this.constantRegenTimer = 0;
        }
        if (this.field_7753 > 0.0f && player.method_7317() && this.field_7756 >= Config.hyperFoodRegenMinimumHunger) {
            ++this.field_7755;
            double d4 = this.field_7755;
            double d5 = Config.hyperFoodRegenRate;
            double d6 = Config.dynamicRegenOnHyperFoodRegen ? dynamicRegenRateModifier : 1.0;
            if (d4 >= d5 * d6) {
                float f = Math.min(this.field_7753, 6.0f);
                this.heal(player, "Hyper", f / 6.0f * Config.hyperFoodRegenHealthMultiplier);
                this.exhaustion("Hyper", f * Config.hyperFoodRegenExhaustionMultiplier);
                this.field_7755 = 0;
            }
        } else if (this.field_7756 >= Config.foodRegenMinimumHunger && player.method_7317()) {
            ++this.field_7755;
            double d7 = this.field_7755;
            double d8 = Config.foodRegenRate;
            double d9 = Config.dynamicRegenOnFoodRegen ? dynamicRegenRateModifier : 1.0;
            if (d7 >= d8 * d9) {
                this.heal(player, "Food", Config.foodRegenHealthAmount);
                this.exhaustion("Food", Config.foodRegenExhaustionAmount);
                this.field_7755 = 0;
            }
        } else {
            return false;
        }
        return true;
    }

    private void heal(class_1657 player, String source, float amount) {
        if (Config.debug) {
            System.out.println("Heal from " + source + ": " + amount);
        }
        player.method_6025(amount);
    }

    private void exhaustion(String source, float amount) {
        if (Config.debug) {
            System.out.println("Exhaustion from " + source + ": " + amount);
        }
        this.method_7583(amount);
    }
}

