/*
 * Decompiled with CFR 0.152.
 */
package com.avro170.discordchatlogger;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Config {
    private Map<String, String> webhooks = new HashMap<String, String>();
    private List<String> blacklist = new ArrayList<String>();
    public boolean logChatMessages = true;
    public boolean logDeathMessages = true;
    public boolean logJoinMessages = true;
    public boolean logLeaveMessages = true;

    public static Config load() {
        Config config;
        File configFile = new File("config/discord-chat-logger.json");
        if (!configFile.exists()) {
            Config config2 = new Config();
            config2.webhooks.put("mc.example.com", "https://discord.com/api/webhooks/...");
            config2.save();
            return config2;
        }
        FileReader reader = new FileReader(configFile);
        try {
            Type type = new TypeToken<Config>(){}.getType();
            config = (Config)new Gson().fromJson((Reader)reader, type);
        }
        catch (Throwable type) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    type.addSuppressed(throwable);
                }
                throw type;
            }
            catch (IOException e) {
                e.printStackTrace();
                Config config3 = new Config();
                config3.save();
                return config3;
            }
        }
        reader.close();
        return config;
    }

    public void save() {
        try (FileWriter writer = new FileWriter("config/discord-chat-logger.json");){
            new Gson().toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getWebhookForServer(String serverAddress) {
        String cleanAddress = serverAddress.split(":")[0];
        return this.webhooks.getOrDefault(cleanAddress, "");
    }

    public List<String> getBlackList() {
        return this.blacklist;
    }
}

