/*
 * Decompiled with CFR 0.152.
 */
package com.avro170.discordchatlogger.mixin;

import com.avro170.discordchatlogger.Config;
import com.avro170.discordchatlogger.DiscordWebhook;
import com.avro170.discordchatlogger.MessageDetector;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_338.class})
public class ChatHudMixin {
    @Inject(method={"addMessage"}, at={@At(value="HEAD")})
    private void onAddMessage(class_2561 text, CallbackInfo ci) {
        class_310 mc;
        String serverIp;
        if (text == null) {
            return;
        }
        String message = text.getString();
        if (message == null || message.isEmpty()) {
            return;
        }
        Config config = Config.load();
        String webhookUrl = config.getWebhookForServer(serverIp = (mc = class_310.method_1551()).method_1558() != null ? mc.method_1558().field_3761 : "singleplayer");
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String sender = this.extractNickUniversal(message);
        if (sender != null && !sender.isEmpty()) {
            for (String blacklistNick : config.getBlackList()) {
                if (!sender.equalsIgnoreCase(blacklistNick)) continue;
                return;
            }
        }
        boolean isDeath = MessageDetector.isDeath(message);
        boolean isJoin = MessageDetector.isJoin(message);
        boolean isLeave = MessageDetector.isLeave(message);
        if (isDeath && !config.logDeathMessages) {
            return;
        }
        if (isJoin && !config.logJoinMessages) {
            return;
        }
        if (isLeave && !config.logLeaveMessages) {
            return;
        }
        if (!(isDeath || isJoin || isLeave || config.logChatMessages)) {
            return;
        }
        new Thread(() -> {
            try {
                DiscordWebhook webhook = new DiscordWebhook(webhookUrl);
                webhook.setContent(message);
                webhook.execute();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    private String extractNickUniversal(String message) {
        String possibleNick;
        int close;
        if (message.startsWith("<") && message.contains(">") && (close = message.indexOf(">")) > 1 && !(possibleNick = message.substring(1, close).trim()).isEmpty()) {
            return possibleNick;
        }
        int colon = message.indexOf(":");
        if (colon > 0 && !(possibleNick = message.substring(0, colon).trim()).isEmpty() && !possibleNick.equalsIgnoreCase("system")) {
            return possibleNick;
        }
        return null;
    }
}

