/*
 * Decompiled with CFR 0.152.
 */
package com.avro170.discordchatlogger;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Config {
    public boolean useWebhookSeparation = false;
    public String defaultWebhook = "https://discord.com/api/webhooks/...";
    private Map<String, String> webhooks = new HashMap<String, String>();
    private List<String> blacklist = new ArrayList<String>();
    public boolean logChatMessages = true;
    public boolean logDeathMessages = true;
    public boolean logJoinMessages = true;
    public boolean logLeaveMessages = true;

    public static Config load() {
        Config config;
        File configFile = new File("config/discord-chat-logger.json");
        if (!configFile.exists()) {
            Config config2 = new Config();
            config2.defaultWebhook = "https://discord.com/api/webhooks/...";
            config2.save();
            return config2;
        }
        FileReader reader = new FileReader(configFile);
        try {
            Type type = new TypeToken<Config>(){}.getType();
            Config cfg = (Config)new Gson().fromJson((Reader)reader, type);
            if (cfg == null) {
                cfg = new Config();
                cfg.save();
            }
            config = cfg;
        }
        catch (Throwable type) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    type.addSuppressed(throwable);
                }
                throw type;
            }
            catch (IOException e) {
                e.printStackTrace();
                Config cfg = new Config();
                cfg.save();
                return cfg;
            }
        }
        reader.close();
        return config;
    }

    public void save() {
        try {
            File dir = new File("config");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            try (FileWriter writer = new FileWriter("config/discord-chat-logger.json");){
                new Gson().toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getWebhookForServer(String serverAddress) {
        if (serverAddress == null || serverAddress.isEmpty()) {
            return this.defaultWebhook;
        }
        String cleanAddress = serverAddress.split(":")[0];
        cleanAddress = cleanAddress.replace("[", "").replace("]", "").replace("/", "").trim().toLowerCase();
        if (this.useWebhookSeparation && this.webhooks.containsKey(cleanAddress)) {
            return this.webhooks.get(cleanAddress);
        }
        return this.defaultWebhook;
    }

    public List<String> getBlackList() {
        return this.blacklist;
    }

    public Map<String, String> getWebhooks() {
        return this.webhooks;
    }
}

