/*
 * Decompiled with CFR 0.152.
 */
package com.avro170.discordchatlogger.mixin;

import com.avro170.discordchatlogger.Config;
import com.avro170.discordchatlogger.DiscordWebhook;
import com.avro170.discordchatlogger.MessageDetector;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_338.class})
public class ChatHudMixin {
    @Inject(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;Lnet/minecraft/client/gui/hud/MessageIndicator;)V"}, at={@At(value="HEAD")})
    private void onAddMessageSigned(class_2561 text, class_7469 signature, class_7591 indicator, CallbackInfo ci) {
        this.handleMessage(text);
    }

    private void handleMessage(class_2561 text) {
        System.out.println("[DCL] ChatHudMixin fired, text = " + String.valueOf(text));
        if (text == null) {
            return;
        }
        String message = text.getString();
        System.out.println("[DCL] message.getString() = " + message);
        if (message == null || message.isEmpty()) {
            return;
        }
        Config config = Config.load();
        class_310 mc = class_310.method_1551();
        String serverIp = mc.method_1558() != null ? mc.method_1558().field_3761 : "singleplayer";
        String webhookUrl = config.getWebhookForServer(serverIp);
        System.out.println("[DCL] webhookUrl = " + webhookUrl);
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        String lower = message.toLowerCase();
        for (String word : config.getBlackList()) {
            if (word == null || word.isEmpty() || !lower.contains(word.toLowerCase())) continue;
            System.out.println("[DCL] blocked by word blacklist: " + word);
            return;
        }
        boolean isDeath = MessageDetector.isDeath(message);
        boolean isJoin = MessageDetector.isJoin(message);
        boolean isLeave = MessageDetector.isLeave(message);
        System.out.println("[DCL] flags: death=" + isDeath + ", join=" + isJoin + ", leave=" + isLeave);
        if (isDeath && !config.logDeathMessages) {
            return;
        }
        if (isJoin && !config.logJoinMessages) {
            return;
        }
        if (isLeave && !config.logLeaveMessages) {
            return;
        }
        if (!(isDeath || isJoin || isLeave || config.logChatMessages)) {
            return;
        }
        new Thread(() -> {
            try {
                System.out.println("[DCL] sending to webhook: " + message);
                DiscordWebhook webhook = new DiscordWebhook(webhookUrl);
                webhook.setContent(message);
                webhook.execute();
                System.out.println("[DCL] sent OK");
            }
            catch (Exception e) {
                System.out.println("[DCL] ERROR while sending webhook");
                e.printStackTrace();
            }
        }).start();
    }

    private String extractNickUniversal(String message) {
        String possible;
        String possible2;
        int lt = message.indexOf(60);
        int gt = message.indexOf(62);
        if (lt != -1 && gt != -1 && gt > lt + 1 && !(possible2 = message.substring(lt + 1, gt).trim()).isEmpty()) {
            return possible2;
        }
        int colon = message.indexOf(58);
        if (colon > 0 && !(possible = message.substring(0, colon).trim()).isEmpty() && !possible.equalsIgnoreCase("system")) {
            return possible;
        }
        return null;
    }
}

