/*
 * Decompiled with CFR 0.152.
 */
package com.avro170.discordchatlogger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public String webhookUrl = "";
    public boolean logChatMessages = true;
    public boolean logDeathMessages = true;
    public boolean logJoinMessages = true;
    public boolean logLeaveMessages = true;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "discord-chat-logger.json");

    public static Config load() {
        if (CONFIG_FILE.exists()) {
            Config config;
            FileReader reader = new FileReader(CONFIG_FILE);
            try {
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("Failed to load config: " + e.getMessage());
                }
            }
            reader.close();
            return config;
        }
        Config config = new Config();
        config.save();
        return config;
    }

    public void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public boolean isLogChatMessages() {
        return this.logChatMessages;
    }

    public boolean isLogDeathMessages() {
        return this.logDeathMessages;
    }

    public boolean isLogJoinMessages() {
        return this.logJoinMessages;
    }

    public boolean isLogLeaveMessages() {
        return this.logLeaveMessages;
    }
}

