/*
 * Decompiled with CFR 0.152.
 */
package com.avro170.discordchatlogger;

import com.avro170.discordchatlogger.PlayerTracker;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;

public class DiscordWebhook {
    private final String url;
    private String content;
    private String username = "Minecraft Chat";

    public DiscordWebhook(String url) {
        this.url = url;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void execute() throws Exception {
        if (this.content == null || this.url == null || this.url.isEmpty()) {
            return;
        }
        URL urlObj = new URL(this.url);
        HttpsURLConnection connection = (HttpsURLConnection)urlObj.openConnection();
        connection.addRequestProperty("Content-Type", "application/json");
        connection.addRequestProperty("User-Agent", "Discord Chat Logger");
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        String jsonPayload = this.buildJsonPayload();
        byte[] postDataBytes = jsonPayload.getBytes(StandardCharsets.UTF_8);
        connection.setFixedLengthStreamingMode(postDataBytes.length);
        try (OutputStream os = connection.getOutputStream();){
            os.write(postDataBytes);
            os.flush();
        }
        int responseCode = connection.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            System.err.println("Discord webhook error: " + responseCode);
        }
        connection.disconnect();
    }

    private String buildJsonPayload() {
        return "{\"username\":\"" + this.escapeJson(this.username) + "\",\"content\":\"" + this.escapeForDiscord(this.content) + "\"}";
    }

    private String escapeForDiscord(String text) {
        if (text == null) {
            return "";
        }
        text = this.escapeJson(text);
        Set<String> onlinePlayers = PlayerTracker.getOnlinePlayers();
        if (onlinePlayers.isEmpty()) {
            return text;
        }
        String result = text;
        for (String playerName : (String[])onlinePlayers.stream().sorted((a, b) -> Integer.compare(b.length(), a.length())).toArray(String[]::new)) {
            result = result.replaceAll("(?<![\\w-_])(" + Pattern.quote(playerName) + ")(?![\\w-_])", "`$1`");
        }
        return result;
    }

    private String escapeJson(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }
}

