/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mobstein.block;

import io.netty.buffer.Unpooled;
import net.mcreator.mobstein.block.entity.OrganExtractorBlockEntity;
import net.mcreator.mobstein.world.inventory.ExtractorGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OrganExtractorBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public OrganExtractorBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getBlock() == this ? true : super.skipRendering(state, adjacentBlockState, side);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)OrganExtractorBlock.box((double)-0.25, (double)4.25, (double)0.0, (double)16.0, (double)6.25, (double)16.0), (VoxelShape[])new VoxelShape[]{OrganExtractorBlock.box((double)0.0, (double)0.0, (double)6.0, (double)2.25, (double)23.0, (double)10.0), OrganExtractorBlock.box((double)13.5, (double)0.0, (double)6.0, (double)15.75, (double)23.0, (double)10.0), OrganExtractorBlock.box((double)7.0, (double)15.75, (double)6.75, (double)9.0, (double)26.5, (double)8.75), OrganExtractorBlock.box((double)-2.25, (double)20.5, (double)7.0, (double)8.5, (double)22.5, (double)8.5), OrganExtractorBlock.box((double)6.65, (double)20.5, (double)7.0, (double)17.4, (double)22.5, (double)8.5), OrganExtractorBlock.box((double)4.5, (double)5.25, (double)3.0, (double)11.25, (double)7.25, (double)13.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)OrganExtractorBlock.box((double)0.0, (double)4.25, (double)0.0, (double)16.25, (double)6.25, (double)16.0), (VoxelShape[])new VoxelShape[]{OrganExtractorBlock.box((double)13.75, (double)0.0, (double)6.0, (double)16.0, (double)23.0, (double)10.0), OrganExtractorBlock.box((double)0.25, (double)0.0, (double)6.0, (double)2.5, (double)23.0, (double)10.0), OrganExtractorBlock.box((double)7.0, (double)15.75, (double)7.25, (double)9.0, (double)26.5, (double)9.25), OrganExtractorBlock.box((double)7.5, (double)20.5, (double)7.5, (double)18.25, (double)22.5, (double)9.0), OrganExtractorBlock.box((double)-1.4, (double)20.5, (double)7.5, (double)9.35, (double)22.5, (double)9.0), OrganExtractorBlock.box((double)4.75, (double)5.25, (double)3.0, (double)11.5, (double)7.25, (double)13.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)OrganExtractorBlock.box((double)0.0, (double)4.25, (double)0.0, (double)16.0, (double)6.25, (double)16.25), (VoxelShape[])new VoxelShape[]{OrganExtractorBlock.box((double)6.0, (double)0.0, (double)13.75, (double)10.0, (double)23.0, (double)16.0), OrganExtractorBlock.box((double)6.0, (double)0.0, (double)0.25, (double)10.0, (double)23.0, (double)2.5), OrganExtractorBlock.box((double)6.75, (double)15.75, (double)7.0, (double)8.75, (double)26.5, (double)9.0), OrganExtractorBlock.box((double)7.0, (double)20.5, (double)7.5, (double)8.5, (double)22.5, (double)18.25), OrganExtractorBlock.box((double)7.0, (double)20.5, (double)-1.4, (double)8.5, (double)22.5, (double)9.35), OrganExtractorBlock.box((double)3.0, (double)5.25, (double)4.75, (double)13.0, (double)7.25, (double)11.5)});
            case Direction.WEST -> Shapes.or((VoxelShape)OrganExtractorBlock.box((double)0.0, (double)4.25, (double)-0.25, (double)16.0, (double)6.25, (double)16.0), (VoxelShape[])new VoxelShape[]{OrganExtractorBlock.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)23.0, (double)2.25), OrganExtractorBlock.box((double)6.0, (double)0.0, (double)13.5, (double)10.0, (double)23.0, (double)15.75), OrganExtractorBlock.box((double)7.25, (double)15.75, (double)7.0, (double)9.25, (double)26.5, (double)9.0), OrganExtractorBlock.box((double)7.5, (double)20.5, (double)-2.25, (double)9.0, (double)22.5, (double)8.5), OrganExtractorBlock.box((double)7.5, (double)20.5, (double)6.65, (double)9.0, (double)22.5, (double)17.4), OrganExtractorBlock.box((double)3.0, (double)5.25, (double)4.5, (double)13.0, (double)7.25, (double)11.25)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Organ Extractor");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new ExtractorGuiMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OrganExtractorBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof OrganExtractorBlockEntity) {
                OrganExtractorBlockEntity be = (OrganExtractorBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof OrganExtractorBlockEntity) {
            OrganExtractorBlockEntity be = (OrganExtractorBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

