/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mobstein.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PolarBodyBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public PolarBodyBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(1.3f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)PolarBodyBlock.box((double)1.0, (double)0.25, (double)1.7, (double)15.0, (double)14.25, (double)12.7), (VoxelShape[])new VoxelShape[]{PolarBodyBlock.box((double)2.0, (double)9.5, (double)3.0, (double)14.0, (double)21.5, (double)13.0), PolarBodyBlock.box((double)10.5, (double)9.7, (double)7.7, (double)14.5, (double)19.7, (double)15.7), PolarBodyBlock.box((double)1.5, (double)10.25, (double)7.75, (double)5.5, (double)20.25, (double)15.75), PolarBodyBlock.box((double)9.5, (double)0.0, (double)12.0, (double)13.5, (double)10.0, (double)18.0), PolarBodyBlock.box((double)2.5, (double)0.0, (double)12.0, (double)6.5, (double)10.0, (double)18.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)PolarBodyBlock.box((double)1.0, (double)0.25, (double)3.3, (double)15.0, (double)14.25, (double)14.3), (VoxelShape[])new VoxelShape[]{PolarBodyBlock.box((double)2.0, (double)9.5, (double)3.0, (double)14.0, (double)21.5, (double)13.0), PolarBodyBlock.box((double)1.5, (double)9.7, (double)0.3, (double)5.5, (double)19.7, (double)8.3), PolarBodyBlock.box((double)10.5, (double)10.25, (double)0.25, (double)14.5, (double)20.25, (double)8.25), PolarBodyBlock.box((double)2.5, (double)0.0, (double)-2.0, (double)6.5, (double)10.0, (double)4.0), PolarBodyBlock.box((double)9.5, (double)0.0, (double)-2.0, (double)13.5, (double)10.0, (double)4.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)PolarBodyBlock.box((double)1.7, (double)0.25, (double)1.0, (double)12.7, (double)14.25, (double)15.0), (VoxelShape[])new VoxelShape[]{PolarBodyBlock.box((double)3.0, (double)9.5, (double)2.0, (double)13.0, (double)21.5, (double)14.0), PolarBodyBlock.box((double)7.7, (double)9.7, (double)1.5, (double)15.7, (double)19.7, (double)5.5), PolarBodyBlock.box((double)7.75, (double)10.25, (double)10.5, (double)15.75, (double)20.25, (double)14.5), PolarBodyBlock.box((double)12.0, (double)0.0, (double)2.5, (double)18.0, (double)10.0, (double)6.5), PolarBodyBlock.box((double)12.0, (double)0.0, (double)9.5, (double)18.0, (double)10.0, (double)13.5)});
            case Direction.WEST -> Shapes.or((VoxelShape)PolarBodyBlock.box((double)3.3, (double)0.25, (double)1.0, (double)14.3, (double)14.25, (double)15.0), (VoxelShape[])new VoxelShape[]{PolarBodyBlock.box((double)3.0, (double)9.5, (double)2.0, (double)13.0, (double)21.5, (double)14.0), PolarBodyBlock.box((double)0.3, (double)9.7, (double)10.5, (double)8.3, (double)19.7, (double)14.5), PolarBodyBlock.box((double)0.25, (double)10.25, (double)1.5, (double)8.25, (double)20.25, (double)5.5), PolarBodyBlock.box((double)-2.0, (double)0.0, (double)9.5, (double)4.0, (double)10.0, (double)13.5), PolarBodyBlock.box((double)-2.0, (double)0.0, (double)2.5, (double)4.0, (double)10.0, (double)6.5)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

