/*
 * Decompiled with CFR 0.152.
 */
package net.zebatek.colorful_bricks.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.zebatek.colorful_bricks.datagen.ModBlockTagGen;
import net.zebatek.colorful_bricks.datagen.ModItemTagGen;
import net.zebatek.colorful_bricks.datagen.ModLootTableProvider;
import net.zebatek.colorful_bricks.datagen.ModModelProvider;
import net.zebatek.colorful_bricks.datagen.ModRecipeProvider;

@EventBusSubscriber(modid="colorful_bricks")
public class DataGen {
    @SubscribeEvent
    public static void gatherClientData(GatherDataEvent.Client gatherDataEvent) {
        DataGenerator dataGenerator = gatherDataEvent.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookup = gatherDataEvent.getLookupProvider();
        dataGenerator.addProvider(true, (DataProvider)new ModBlockTagGen(packOutput, lookup));
        dataGenerator.addProvider(true, (DataProvider)new ModModelProvider(packOutput));
        dataGenerator.addProvider(true, (DataProvider)ModLootTableProvider.create(packOutput, lookup));
        dataGenerator.addProvider(true, (DataProvider)new ModItemTagGen(packOutput, lookup));
        dataGenerator.addProvider(true, (DataProvider)new ModRecipeProvider.Runner(packOutput, lookup));
    }

    @SubscribeEvent
    public static void gatherServerData(GatherDataEvent.Server gatherDataEvent) {
        DataGenerator dataGenerator = gatherDataEvent.getGenerator();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookup = gatherDataEvent.getLookupProvider();
        dataGenerator.addProvider(true, (DataProvider)new ModBlockTagGen(packOutput, lookup));
        dataGenerator.addProvider(true, (DataProvider)new ModModelProvider(packOutput));
        dataGenerator.addProvider(true, (DataProvider)ModLootTableProvider.create(packOutput, lookup));
        dataGenerator.addProvider(true, (DataProvider)new ModItemTagGen(packOutput, lookup));
        dataGenerator.addProvider(true, (DataProvider)new ModRecipeProvider.Runner(packOutput, lookup));
    }
}

