/*
 * Decompiled with CFR 0.152.
 */
package net.zebatek.colorful_bricks.datagen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.data.BlockFamily;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.zebatek.colorful_bricks.datagen.ModBlockFamilies;
import org.jetbrains.annotations.NotNull;

public class ModModelGenerator
extends BlockModelGenerators {
    static final ImmutableMap<BlockFamily.Variant, BiConsumer<ModBlockFamilyProvider, Block>> SHAPE_CONSUMERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.SLAB, ModBlockFamilyProvider::slab).put((Object)BlockFamily.Variant.STAIRS, ModBlockFamilyProvider::stairs).put((Object)BlockFamily.Variant.WALL, ModBlockFamilyProvider::wall).build();

    public ModModelGenerator(Consumer<BlockModelDefinitionGenerator> p_378137_, ItemModelOutput p_378502_, BiConsumer<ResourceLocation, ModelInstance> p_378240_) {
        super(p_378137_, p_378502_, p_378240_);
    }

    public void run() {
        ModBlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateModel).forEach(p_375984_ -> this.family(p_375984_.getBaseBlock()).generateFor(p_375984_));
    }

    public class ModBlockFamilyProvider
    extends BlockModelGenerators.BlockFamilyProvider {
        private final TextureMapping mapping;
        private final Map<ModelTemplate, ResourceLocation> models;
        @Nullable
        private BlockFamily family;
        @Nullable
        private Variant fullBlock;
        private final Set<Block> skipGeneratingModelsFor;

        public ModBlockFamilyProvider(TextureMapping pMapping) {
            super((BlockModelGenerators)ModModelGenerator.this, pMapping);
            this.models = Maps.newHashMap();
            this.skipGeneratingModelsFor = new HashSet<Block>();
            this.mapping = pMapping;
        }

        @NotNull
        public BlockModelGenerators.BlockFamilyProvider generateFor(BlockFamily pFamily) {
            this.family = pFamily;
            pFamily.getVariants().forEach((p_375413_, p_375795_) -> {
                BiConsumer biconsumer;
                if (!this.skipGeneratingModelsFor.contains(p_375795_) && (biconsumer = (BiConsumer)SHAPE_CONSUMERS.get(p_375413_)) != null) {
                    biconsumer.accept(this, p_375795_);
                }
            });
            return this;
        }

        public BlockModelGenerators.BlockFamilyProvider wall(Block p_377084_) {
            MultiVariant multivariant = ModModelGenerator.plainVariant((ResourceLocation)ModelTemplates.WALL_POST.create(p_377084_, this.mapping, ModModelGenerator.this.modelOutput));
            MultiVariant multivariant1 = ModModelGenerator.plainVariant((ResourceLocation)ModelTemplates.WALL_LOW_SIDE.create(p_377084_, this.mapping, ModModelGenerator.this.modelOutput));
            MultiVariant multivariant2 = ModModelGenerator.plainVariant((ResourceLocation)ModelTemplates.WALL_TALL_SIDE.create(p_377084_, this.mapping, ModModelGenerator.this.modelOutput));
            ModModelGenerator.this.blockStateOutput.accept(ModModelGenerator.createWall((Block)p_377084_, (MultiVariant)multivariant, (MultiVariant)multivariant1, (MultiVariant)multivariant2));
            ResourceLocation resourcelocation = ModelTemplates.WALL_INVENTORY.create(p_377084_, this.mapping, ModModelGenerator.this.modelOutput);
            ModModelGenerator.this.registerSimpleItemModel(p_377084_, resourcelocation);
            return this;
        }

        public BlockModelGenerators.BlockFamilyProvider slab(Block p_377334_) {
            if (this.fullBlock == null) {
                throw new IllegalStateException("Full block not generated yet");
            }
            ResourceLocation resourcelocation = this.getOrCreateModel(ModelTemplates.SLAB_BOTTOM, p_377334_);
            MultiVariant multivariant = ModModelGenerator.plainVariant((ResourceLocation)this.getOrCreateModel(ModelTemplates.SLAB_TOP, p_377334_));
            ModModelGenerator.this.blockStateOutput.accept(ModModelGenerator.createSlab((Block)p_377334_, (MultiVariant)ModModelGenerator.plainVariant((ResourceLocation)resourcelocation), (MultiVariant)multivariant, (MultiVariant)ModModelGenerator.variant((Variant)this.fullBlock)));
            ModModelGenerator.this.registerSimpleItemModel(p_377334_, resourcelocation);
            return this;
        }

        public BlockModelGenerators.BlockFamilyProvider stairs(Block p_376299_) {
            MultiVariant multivariant = ModModelGenerator.plainVariant((ResourceLocation)this.getOrCreateModel(ModelTemplates.STAIRS_INNER, p_376299_));
            ResourceLocation resourcelocation = this.getOrCreateModel(ModelTemplates.STAIRS_STRAIGHT, p_376299_);
            MultiVariant multivariant1 = ModModelGenerator.plainVariant((ResourceLocation)this.getOrCreateModel(ModelTemplates.STAIRS_OUTER, p_376299_));
            ModModelGenerator.this.blockStateOutput.accept(ModModelGenerator.createStairs((Block)p_376299_, (MultiVariant)multivariant, (MultiVariant)ModModelGenerator.plainVariant((ResourceLocation)resourcelocation), (MultiVariant)multivariant1));
            ModModelGenerator.this.registerSimpleItemModel(p_376299_, resourcelocation);
            return this;
        }
    }
}

