/*
 * Decompiled with CFR 0.152.
 */
package net.zebatek.colorful_bricks.datagen;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import net.zebatek.colorful_bricks.block.ColorfulBricksBlocks;
import net.zebatek.colorful_bricks.datagen.ModModelGenerator;
import org.jetbrains.annotations.NotNull;

public class ModModelProvider
extends ModelProvider {
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider itemInfoPathProvider;
    private final PackOutput.PathProvider modelPathProvider;

    public ModModelProvider(PackOutput pOutput) {
        super(pOutput);
        this.blockStatePathProvider = pOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.itemInfoPathProvider = pOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "items");
        this.modelPathProvider = pOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
    }

    @NotNull
    protected Stream<Block> getKnownBlocks() {
        return ColorfulBricksBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get);
    }

    @NotNull
    protected Stream<Item> getKnownItems() {
        return ColorfulBricksBlocks.ITEMS.getEntries().stream().map(RegistryObject::get);
    }

    @NotNull
    protected BlockModelGenerators getBlockModelGenerators(@NotNull ModelProvider.BlockStateGeneratorCollector blocks, @NotNull ModelProvider.ItemInfoCollector items, @NotNull ModelProvider.SimpleModelCollector models) {
        return new ModModelGenerator((Consumer<BlockModelDefinitionGenerator>)blocks, (ItemModelOutput)items, (BiConsumer<ResourceLocation, ModelInstance>)models);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput coutput) {
        ModItemInfoCollector modelprovider$iteminfocollector = new ModItemInfoCollector(this::getKnownItems);
        ModelProvider.BlockStateGeneratorCollector modelprovider$blockstategeneratorcollector = new ModelProvider.BlockStateGeneratorCollector(this::getKnownBlocks);
        ModelProvider.SimpleModelCollector modelprovider$simplemodelcollector = new ModelProvider.SimpleModelCollector();
        this.getBlockModelGenerators(modelprovider$blockstategeneratorcollector, modelprovider$iteminfocollector, modelprovider$simplemodelcollector).run();
        this.getItemModelGenerators(modelprovider$iteminfocollector, modelprovider$simplemodelcollector).run();
        modelprovider$blockstategeneratorcollector.validate();
        modelprovider$iteminfocollector.finalizeAndValidate();
        return CompletableFuture.allOf(modelprovider$blockstategeneratorcollector.save(coutput, this.blockStatePathProvider), modelprovider$simplemodelcollector.save(coutput, this.modelPathProvider), modelprovider$iteminfocollector.save(coutput, this.itemInfoPathProvider));
    }

    public static class ModItemInfoCollector
    extends ModelProvider.ItemInfoCollector {
        private final Map<Item, ClientItem> itemInfos = new HashMap<Item, ClientItem>();
        private final Map<Item, Item> copies = new HashMap<Item, Item>();
        private final Supplier<Stream<Item>> known;

        public ModItemInfoCollector(Supplier<Stream<Item>> known) {
            this.known = known;
        }

        public void accept(@NotNull Item p_376450_, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ItemModel.Unbaked p_378513_) {
            this.register(p_376450_, new ClientItem(p_378513_, ClientItem.Properties.DEFAULT));
        }

        private void register(Item pItem, ClientItem pClientItem) {
            ClientItem clientitem = this.itemInfos.put(pItem, pClientItem);
            if (clientitem != null) {
                throw new IllegalStateException("Duplicate item model definition for " + String.valueOf(pItem));
            }
        }

        public void copy(@NotNull Item p_377438_, @NotNull Item p_376965_) {
            this.copies.put(p_376965_, p_377438_);
        }

        public void generateDefaultBlockModels() {
            ColorfulBricksBlocks.ITEMS.getEntries().stream().map(RegistryObject::get).forEach(p_378629_ -> {
                BlockItem blockitem;
                if (!this.copies.containsKey(p_378629_) && p_378629_ instanceof BlockItem && !this.itemInfos.containsKey(blockitem = (BlockItem)p_378629_)) {
                    ResourceLocation resourcelocation = ModelLocationUtils.getModelLocation((Block)blockitem.getBlock());
                    this.accept((Item)blockitem, ItemModelUtils.plainModel((ResourceLocation)resourcelocation));
                }
            });
        }

        public void finalizeAndValidate() {
            this.copies.forEach((p_376289_, p_375718_) -> {
                ClientItem clientitem = this.itemInfos.get(p_375718_);
                if (clientitem == null) {
                    throw new IllegalStateException("Missing donor: " + String.valueOf(p_375718_) + " -> " + String.valueOf(p_376289_));
                }
                this.register((Item)p_376289_, clientitem);
            });
            List<ResourceLocation> list = this.known.get().map(item -> item.builtInRegistryHolder()).filter(p_377225_ -> !this.itemInfos.containsKey(p_377225_.value())).map(p_378591_ -> p_378591_.key().location()).toList();
            if (!list.isEmpty()) {
                throw new IllegalStateException("Missing item model definitions for: " + String.valueOf(list));
            }
        }

        @NotNull
        public CompletableFuture<?> save(@NotNull CachedOutput pOutput, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull PackOutput.PathProvider pPathProvider) {
            return DataProvider.saveAll((CachedOutput)pOutput, (Codec)ClientItem.CODEC, p_377091_ -> pPathProvider.json(p_377091_.builtInRegistryHolder().key().location()), this.itemInfos);
        }
    }
}

