/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.rpgclassselection;

import com.github.theredbrain.rpgclassselection.compat.RPGInventoryCompat;
import com.github.theredbrain.rpgclassselection.component.type.ClassStateComponent;
import com.github.theredbrain.rpgclassselection.config.ServerConfig;
import com.github.theredbrain.rpgclassselection.data.RPGClass;
import com.github.theredbrain.rpgclassselection.registry.BlockRegistry;
import com.github.theredbrain.rpgclassselection.registry.CustomDynamicRegistries;
import com.github.theredbrain.rpgclassselection.registry.DataComponentRegistry;
import com.github.theredbrain.rpgclassselection.registry.EntityRegistry;
import com.github.theredbrain.rpgclassselection.registry.ScreenHandlerTypesRegistry;
import com.github.theredbrain.rpgclassselection.registry.ServerEventRegistry;
import com.github.theredbrain.rpgclassselection.registry.ServerPacketRegistry;
import com.github.theredbrain.rpgclassselection.screen.ClassSelectionScreenHandler;
import com.github.theredbrain.rpgclassselection.screen.RPGSeriesClassSelectionScreenHandler;
import com.github.theredbrain.rpgclassselection.screen.ThreeUpgradesClassSelectionScreenHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_8779;
import net.minecraft.class_9274;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPGClassSelection
implements ModInitializer {
    public static final String MOD_ID = "rpgclassselection";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rpgclassselection");
    public static ServerConfig SERVER_CONFIG;
    public static class_9331<ClassStateComponent> CLASS_STATE_COMPONENT_TYPE;

    public static class_9274 getClassItemAttributeModifierSlot() {
        class_9274 attributeModifierSlot = class_9274.field_49216;
        attributeModifierSlot = RPGInventoryCompat.getClassItemAttributeModifierSlot();
        return attributeModifierSlot;
    }

    public static class_1799 getClassItemStack(class_1657 player) {
        class_1799 classItemStack = class_1799.field_8037;
        classItemStack = RPGInventoryCompat.getClassItemStack(player);
        return classItemStack;
    }

    public static void setClassItemStack(class_1657 player, class_1799 classItemStack) {
        RPGInventoryCompat.setClassItemStack(player, classItemStack);
    }

    public static void openRPGClassSelectionScreen(class_3222 player, String initial_class_identifier_string, boolean restrict_class_list, boolean allow_changing_class, boolean allow_changing_upgrades) {
        MinecraftServer server = player.field_13995;
        if (server != null) {
            class_2985 playerAdvancementTracker = player.method_14236();
            class_2989 serverAdvancementLoader = server.method_3851();
            if (serverAdvancementLoader != null && playerAdvancementTracker != null) {
                class_1799 currentClassItemStack = RPGClassSelection.getClassItemStack((class_1657)player);
                final ClassStateComponent.ActiveClassState activeClassState = ((ClassStateComponent)currentClassItemStack.method_57825(CLASS_STATE_COMPONENT_TYPE, (Object)ClassStateComponent.DEFAULT)).activeClassState();
                String currentClassIdentifierString = activeClassState.activeClassIdentifier();
                if (initial_class_identifier_string.isEmpty() && allow_changing_class) {
                    initial_class_identifier_string = currentClassIdentifierString;
                }
                final ArrayList<ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData> classUnlockStateDataList = new ArrayList<ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData>();
                final ArrayList<RPGClass> rpgClassList = new ArrayList<RPGClass>();
                if (allow_changing_class || currentClassIdentifierString.isEmpty()) {
                    classUnlockStateDataList.add(new ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData(true, new ArrayList<ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData.UpgradeUnlockStateData>()));
                    rpgClassList.add(RPGClass.DEFAULT);
                }
                int initialClassIndex = 0;
                int classIndex = 0;
                ClassSelectionScreenHandler.EmptyUpgradeMode emptyUpgradeMode = (ClassSelectionScreenHandler.EmptyUpgradeMode)((Object)RPGClassSelection.SERVER_CONFIG.empty_upgrade_mode.get());
                for (Map.Entry entry : player.method_37908().method_30349().method_30530(CustomDynamicRegistries.RPG_CLASS_REGISTRY_KEY).method_29722()) {
                    class_8779 unlockAdvancementEntry;
                    RPGClass rpgClass = (RPGClass)entry.getValue();
                    boolean isClassUnlocked = true;
                    ArrayList<ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData.UpgradeUnlockStateData> upgradeUnlockStateDataList = new ArrayList<ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData.UpgradeUnlockStateData>();
                    String unlockAdvancementIdentifierString = rpgClass.unlock_advancement_identifier();
                    if (!unlockAdvancementIdentifierString.isEmpty() && (unlockAdvancementEntry = serverAdvancementLoader.method_12896(class_2960.method_60654((String)unlockAdvancementIdentifierString))) != null) {
                        isClassUnlocked = playerAdvancementTracker.method_12882(unlockAdvancementEntry).method_740();
                    }
                    ArrayList<RPGClass.UpgradeEntryGroup> upgradeEntryGroupList = new ArrayList<RPGClass.UpgradeEntryGroup>();
                    if (isClassUnlocked) {
                        int groupIndex = 0;
                        for (RPGClass.UpgradeEntryGroup upgradeEntryGroup : rpgClass.upgrade_entry_group_list()) {
                            boolean groupEntryListIsEmpty;
                            ArrayList<RPGClass.UpgradeEntryGroup.UpgradeEntry> upgradeEntryList = new ArrayList<RPGClass.UpgradeEntryGroup.UpgradeEntry>();
                            ArrayList<Boolean> upgradeUnlockStatesList = new ArrayList<Boolean>();
                            String currentUpgradeIdentifierString = "";
                            if (groupIndex < activeClassState.activeUpgradeIdentifierList().size()) {
                                currentUpgradeIdentifierString = activeClassState.activeUpgradeIdentifierList().get(groupIndex);
                            }
                            if (!(groupEntryListIsEmpty = upgradeEntryGroup.upgrade_entry_list().isEmpty()) && allow_changing_upgrades && emptyUpgradeMode == ClassSelectionScreenHandler.EmptyUpgradeMode.NON_EMPTY_GROUPS || groupEntryListIsEmpty && emptyUpgradeMode == ClassSelectionScreenHandler.EmptyUpgradeMode.EMPTY_GROUPS || (allow_changing_upgrades || groupEntryListIsEmpty) && emptyUpgradeMode == ClassSelectionScreenHandler.EmptyUpgradeMode.ALWAYS) {
                                upgradeEntryList.add(RPGClass.UpgradeEntryGroup.UpgradeEntry.DEFAULT);
                                upgradeUnlockStatesList.add(true);
                            }
                            for (RPGClass.UpgradeEntryGroup.UpgradeEntry upgradeEntry : upgradeEntryGroup.upgrade_entry_list()) {
                                class_8779 unlockAdvancementEntry2;
                                boolean isUpgradeUnlocked = true;
                                unlockAdvancementIdentifierString = upgradeEntry.unlock_advancement_identifier();
                                if (!unlockAdvancementIdentifierString.isEmpty() && (unlockAdvancementEntry2 = serverAdvancementLoader.method_12896(class_2960.method_60654((String)unlockAdvancementIdentifierString))) != null) {
                                    isUpgradeUnlocked = playerAdvancementTracker.method_12882(unlockAdvancementEntry2).method_740();
                                }
                                if (!isUpgradeUnlocked && !upgradeEntry.visible_when_locked() || !allow_changing_upgrades && !Objects.equals(upgradeEntry.upgrade_identifier(), currentUpgradeIdentifierString)) continue;
                                upgradeEntryList.add(upgradeEntry);
                                upgradeUnlockStatesList.add(isUpgradeUnlocked);
                            }
                            upgradeEntryGroupList.add(new RPGClass.UpgradeEntryGroup(upgradeEntryList));
                            upgradeUnlockStateDataList.add(new ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData.UpgradeUnlockStateData(upgradeUnlockStatesList));
                            ++groupIndex;
                        }
                    }
                    boolean isCurrentClass = ((class_5321)entry.getKey()).method_29177().toString().equals(currentClassIdentifierString);
                    boolean isInitialClass = ((class_5321)entry.getKey()).method_29177().toString().equals(initial_class_identifier_string);
                    if (!isClassUnlocked && !rpgClass.visible_when_locked() && !isCurrentClass || !isCurrentClass && !allow_changing_class || restrict_class_list && !isInitialClass && !isCurrentClass && !initial_class_identifier_string.isEmpty()) continue;
                    classUnlockStateDataList.add(new ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData(isClassUnlocked, upgradeUnlockStateDataList));
                    rpgClassList.add(new RPGClass(rpgClass.class_identifier(), rpgClass.unlock_advancement_identifier(), rpgClass.class_item_identifier(), rpgClass.visible_when_locked(), rpgClass.description(), rpgClass.locked_description(), upgradeEntryGroupList));
                    ++classIndex;
                    if (!((class_5321)entry.getKey()).method_29177().toString().equals(initial_class_identifier_string)) continue;
                    initialClassIndex = classIndex;
                }
                final int finalInitialClassIndex = initialClassIndex;
                player.method_17355((class_3908)new ExtendedScreenHandlerFactory<Object>(){

                    public ClassSelectionScreenHandler.ClassSelectionScreenData getScreenOpeningData(class_3222 player) {
                        return new ClassSelectionScreenHandler.ClassSelectionScreenData(finalInitialClassIndex, activeClassState, classUnlockStateDataList, rpgClassList);
                    }

                    public class_2561 method_5476() {
                        return class_2561.method_43471((String)"Class Selection");
                    }

                    @Nullable
                    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                        if (RPGClassSelection.SERVER_CONFIG.class_selection_screen_type.get() == ClassSelectionScreenHandler.ClassSelectionScreenType.RPG_SERIES) {
                            return new RPGSeriesClassSelectionScreenHandler(syncId, playerInventory, finalInitialClassIndex, activeClassState, classUnlockStateDataList, rpgClassList);
                        }
                        return new ThreeUpgradesClassSelectionScreenHandler(syncId, playerInventory, finalInitialClassIndex, activeClassState, classUnlockStateDataList, rpgClassList);
                    }
                });
            }
        }
    }

    public void onInitialize() {
        LOGGER.info("Initializing class selection!");
        SERVER_CONFIG = (ServerConfig)ConfigApiJava.registerAndLoadConfig(ServerConfig::new);
        BlockRegistry.init();
        CustomDynamicRegistries.init();
        DataComponentRegistry.init();
        EntityRegistry.init();
        ScreenHandlerTypesRegistry.registerAll();
        ServerEventRegistry.initializeServerEvents();
        ServerPacketRegistry.init();
        Optional modContainer = FabricLoader.getInstance().getModContainer(MOD_ID);
        if (modContainer.isPresent()) {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)RPGClassSelection.identifier("more_rpg_series_classes"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"resourcepack.rpgclassselection.more_rpg_series_classes.name"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)RPGClassSelection.identifier("rpg_series_classes"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"resourcepack.rpgclassselection.rpg_series_classes.name"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)RPGClassSelection.identifier("compat_pack_resources"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"resourcepack.rpgclassselection.compat_pack_resources.name"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
        }
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void info(String message) {
        LOGGER.info("[rpgclassselection] [info]: " + message);
    }

    public static void warn(String message) {
        LOGGER.warn("[rpgclassselection] [warn]: " + message);
    }
}

