/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.rpgclassselection.gui.screen.ingame;

import com.github.theredbrain.rpgclassselection.RPGClassSelection;
import com.github.theredbrain.rpgclassselection.component.type.ClassStateComponent;
import com.github.theredbrain.rpgclassselection.data.RPGClass;
import com.github.theredbrain.rpgclassselection.network.packet.UpdateClassPacket;
import com.github.theredbrain.rpgclassselection.screen.ClassSelectionScreenHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9285;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.client.gui.SpellTooltip;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractClassSelectionScreen
extends class_465<ClassSelectionScreenHandler> {
    protected static final class_2960 SCROLL_BAR_BACKGROUND_TEXTURE = RPGClassSelection.identifier("scroll_bar/scroll_bar_background");
    protected static final class_2960 SCROLLER_TEXTURE = RPGClassSelection.identifier("scroll_bar/scroller_vertical_6_7");
    public static class_2960 BACKGROUND_TEXTURE;
    protected static final class_2561 CHOOSE_CLASS_BUTTON_LABEL_TEXT;
    protected ClassStateComponent.ActiveClassState newActiveClassState;
    protected int currentClassIndex;
    protected String activeClassDescription = "";
    protected final List<Integer> currentUpgradeIndexList = new ArrayList<Integer>();

    public AbstractClassSelectionScreen(ClassSelectionScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    public void method_25410(class_310 client, int width, int height) {
        ClassStateComponent.ActiveClassState var = this.newActiveClassState;
        int integer = this.currentClassIndex;
        String string = this.activeClassDescription;
        ArrayList<Integer> list = new ArrayList<Integer>(this.currentUpgradeIndexList);
        this.method_25423(client, width, height);
        this.newActiveClassState = var;
        this.currentClassIndex = integer;
        this.activeClassDescription = string;
        this.currentUpgradeIndexList.clear();
        this.currentUpgradeIndexList.addAll(list);
        this.updateWidgets();
    }

    protected void cycleClassIndexBackwards() {
        int index = this.currentClassIndex;
        if (--index < 0) {
            index = ((ClassSelectionScreenHandler)this.field_2797).getRpgClassList().size() - 1;
        }
        this.currentClassIndex = index;
    }

    protected void cycleClassIndexForwards() {
        int index = this.currentClassIndex;
        if (++index >= ((ClassSelectionScreenHandler)this.field_2797).getRpgClassList().size()) {
            index = 0;
        }
        this.currentClassIndex = index;
    }

    protected void cycleUpgradeIndexBackwards(int upgradeIndex) {
        if (upgradeIndex < this.currentUpgradeIndexList.size()) {
            int index = this.currentUpgradeIndexList.get(upgradeIndex);
            List<ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData.UpgradeUnlockStateData> unlockStateList = ((ClassSelectionScreenHandler)this.field_2797).getClassUnlockStateDataList().get(this.currentClassIndex).upgradeUnlockStateDataList();
            if (upgradeIndex < unlockStateList.size()) {
                int stateListSize = unlockStateList.get(upgradeIndex).upgradeUnlockStatesList().size();
                if (--index < 0) {
                    index = stateListSize - 1;
                }
                this.currentUpgradeIndexList.set(upgradeIndex, index);
            }
        }
    }

    protected void cycleUpgradeIndexForwards(int upgradeIndex) {
        if (upgradeIndex < this.currentUpgradeIndexList.size()) {
            int index = this.currentUpgradeIndexList.get(upgradeIndex);
            List<ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData.UpgradeUnlockStateData> unlockStateList = ((ClassSelectionScreenHandler)this.field_2797).getClassUnlockStateDataList().get(this.currentClassIndex).upgradeUnlockStateDataList();
            if (upgradeIndex < unlockStateList.size()) {
                int stateListSize = unlockStateList.get(upgradeIndex).upgradeUnlockStatesList().size();
                if (++index >= stateListSize) {
                    index = 0;
                }
                this.currentUpgradeIndexList.set(upgradeIndex, index);
            }
        }
    }

    protected void cycleClassBackwards() {
        this.cycleClassIndexBackwards();
        this.resetCurrentUpgradeIndexes();
        this.updateActiveClassState();
    }

    protected void cycleClassForwards() {
        this.cycleClassIndexForwards();
        this.resetCurrentUpgradeIndexes();
        this.updateActiveClassState();
    }

    protected void cycleUpgradeBackwards(int index) {
        this.cycleUpgradeIndexBackwards(index);
        this.updateActiveClassState();
    }

    protected void cycleUpgradeForwards(int index) {
        this.cycleUpgradeIndexForwards(index);
        this.updateActiveClassState();
    }

    protected void resetCurrentUpgradeIndexes() {
        this.currentUpgradeIndexList.clear();
        RPGClass rpgClass = ((ClassSelectionScreenHandler)this.field_2797).getRpgClassList().get(this.currentClassIndex);
        if (Objects.equals(rpgClass.class_identifier(), ((ClassSelectionScreenHandler)this.field_2797).getActiveClassState().activeClassIdentifier())) {
            List<String> list = ((ClassSelectionScreenHandler)this.field_2797).getActiveClassState().activeUpgradeIdentifierList();
            block0: for (int i = 0; i < list.size(); ++i) {
                String upgradeIdentifier = list.get(i);
                if (!upgradeIdentifier.isEmpty() && i < rpgClass.upgrade_entry_group_list().size()) {
                    List<RPGClass.UpgradeEntryGroup.UpgradeEntry> upgradeEntryList = rpgClass.upgrade_entry_group_list().get(i).upgrade_entry_list();
                    for (int j = 0; j < upgradeEntryList.size(); ++j) {
                        RPGClass.UpgradeEntryGroup.UpgradeEntry upgradeEntry = upgradeEntryList.get(j);
                        if (!upgradeIdentifier.equals(upgradeEntry.upgrade_identifier())) continue;
                        this.currentUpgradeIndexList.add(j);
                        continue block0;
                    }
                    continue;
                }
                this.currentUpgradeIndexList.add(0);
            }
        } else {
            for (int i = 0; i < rpgClass.upgrade_entry_group_list().size(); ++i) {
                this.currentUpgradeIndexList.add(0);
            }
        }
    }

    protected void updateActiveClassState() {
        RPGClass rpgClass = ((ClassSelectionScreenHandler)this.field_2797).getRpgClassList().get(this.currentClassIndex);
        List<String> activeUpgradeIdentifierList = this.getActiveUpgradeIdentifierList();
        this.newActiveClassState = new ClassStateComponent.ActiveClassState(rpgClass.class_identifier(), activeUpgradeIdentifierList);
        this.activeClassDescription = ((ClassSelectionScreenHandler)this.field_2797).getClassUnlockStateDataList().get(this.currentClassIndex).classUnlockState() ? rpgClass.description() : rpgClass.locked_description();
        this.updateWidgets();
    }

    private List<String> getActiveUpgradeIdentifierList() {
        ArrayList<String> activeUpgradeIdentifierList = new ArrayList<String>();
        RPGClass rpgClass = ((ClassSelectionScreenHandler)this.field_2797).getRpgClassList().get(this.currentClassIndex);
        List<ClassSelectionScreenHandler.ClassSelectionScreenData.ClassUnlockStateData.UpgradeUnlockStateData> upgradeUnlockStateDataList = ((ClassSelectionScreenHandler)this.field_2797).getClassUnlockStateDataList().get(this.currentClassIndex).upgradeUnlockStateDataList();
        List<RPGClass.UpgradeEntryGroup> upgradeEntryGroupList = rpgClass.upgrade_entry_group_list();
        for (int i = 0; i < upgradeEntryGroupList.size(); ++i) {
            if (i >= this.currentUpgradeIndexList.size() || i >= upgradeUnlockStateDataList.size()) continue;
            int currentUpgradeIndex = this.currentUpgradeIndexList.get(i);
            List<RPGClass.UpgradeEntryGroup.UpgradeEntry> upgradeEntryList = upgradeEntryGroupList.get(i).upgrade_entry_list();
            List<Boolean> upgradeUnlockStatesList = upgradeUnlockStateDataList.get(i).upgradeUnlockStatesList();
            if (currentUpgradeIndex < upgradeEntryList.size() && currentUpgradeIndex < upgradeUnlockStatesList.size() && upgradeUnlockStatesList.get(currentUpgradeIndex).booleanValue()) {
                activeUpgradeIdentifierList.add(upgradeEntryList.get(currentUpgradeIndex).upgrade_identifier());
                continue;
            }
            activeUpgradeIdentifierList.add("");
        }
        return activeUpgradeIdentifierList;
    }

    protected void chooseClass() {
        ClientPlayNetworking.send((class_8710)new UpdateClassPacket(this.newActiveClassState));
    }

    protected void updateWidgets() {
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        this.drawClassTitleAndDescription(context);
        this.drawUpgradeEntryTitles(context);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25290(BACKGROUND_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
        this.drawUpgradeEntryIcons(context);
    }

    protected List<class_2561> getUpgradeEntryTooltipList(RPGClass.UpgradeEntryGroup.UpgradeEntry upgradeEntry) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        for (RPGClass.UpgradeEntryGroup.UpgradeEntry.UpgradeEntryComponent upgradeEntryComponent : upgradeEntry.component_list()) {
            Optional optionalEntityAttributeReference;
            if (Objects.equals(upgradeEntryComponent.type(), RPGClass.UpgradeEntryGroup.UpgradeEntry.UpgradeEntryComponent.Type.SPELL.method_15434())) {
                Optional optionalSpellReference = ((ClassSelectionScreenHandler)this.field_2797).getWorld().method_30349().method_30530(SpellRegistry.KEY).method_55841(class_2960.method_60654((String)upgradeEntryComponent.spell_identifier()));
                if (!optionalSpellReference.isPresent() || ((ClassSelectionScreenHandler)this.field_2797).getPlayer() == null) continue;
                list.addAll(SpellTooltip.spellEntry((class_6880)((class_6880)optionalSpellReference.get()), (class_1657)((ClassSelectionScreenHandler)this.field_2797).getPlayer(), (class_1799)class_1799.field_8037, (boolean)true, (int)0));
                continue;
            }
            if (!Objects.equals(upgradeEntryComponent.type(), RPGClass.UpgradeEntryGroup.UpgradeEntry.UpgradeEntryComponent.Type.ATTRIBUTE_MODIFIER.method_15434()) || !(optionalEntityAttributeReference = ((ClassSelectionScreenHandler)this.field_2797).getWorld().method_30349().method_30530(class_7924.field_41251).method_55841(class_2960.method_60654((String)upgradeEntryComponent.attribute_identifier()))).isPresent()) continue;
            class_6880 entityAttributeRegistryEntry = (class_6880)optionalEntityAttributeReference.get();
            double d = upgradeEntryComponent.attribute_modifier_amount();
            class_1322.class_1323 entityAttributeModifierOperation = null;
            try {
                entityAttributeModifierOperation = class_1322.class_1323.valueOf((String)upgradeEntryComponent.attribute_modifier_operation());
            }
            catch (IllegalArgumentException e) {
                RPGClassSelection.warn(e.getMessage());
            }
            if (entityAttributeModifierOperation == null) continue;
            double displayAmount = entityAttributeModifierOperation == class_1322.class_1323.field_6330 || entityAttributeModifierOperation == class_1322.class_1323.field_6331 ? d * 100.0 : (entityAttributeRegistryEntry.method_55838(class_5134.field_23718) ? d * 10.0 : d);
            if (d > 0.0) {
                list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + entityAttributeModifierOperation.method_56082()), (Object[])new Object[]{class_9285.field_49329.format(displayAmount), class_2561.method_43471((String)((class_1320)entityAttributeRegistryEntry.comp_349()).method_26830())}).method_27692(((class_1320)entityAttributeRegistryEntry.comp_349()).method_60494(true)));
                continue;
            }
            if (!(d < 0.0)) continue;
            list.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + entityAttributeModifierOperation.method_56082()), (Object[])new Object[]{class_9285.field_49329.format(-displayAmount), class_2561.method_43471((String)((class_1320)entityAttributeRegistryEntry.comp_349()).method_26830())}).method_27692(((class_1320)entityAttributeRegistryEntry.comp_349()).method_60494(false)));
        }
        return list;
    }

    protected void drawClassTitleAndDescription(class_332 context) {
    }

    protected void drawUpgradeEntryIcons(class_332 context) {
        this.drawUpgradeEntries(context, true);
    }

    protected void drawUpgradeEntryTitles(class_332 context) {
        this.drawUpgradeEntries(context, false);
    }

    protected void drawUpgradeEntries(class_332 context, boolean background) {
    }

    static {
        CHOOSE_CLASS_BUTTON_LABEL_TEXT = class_2561.method_43471((String)"class_selection_screen.choose_class_button_label");
    }
}

