/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.rpgclassselection.network.packet;

import com.github.theredbrain.rpgclassselection.RPGClassSelection;
import com.github.theredbrain.rpgclassselection.component.type.ClassStateComponent;
import com.github.theredbrain.rpgclassselection.data.RPGClass;
import com.github.theredbrain.rpgclassselection.network.packet.UpdateClassPacket;
import com.github.theredbrain.rpgclassselection.registry.CustomDynamicRegistries;
import com.github.theredbrain.rpgclassselection.screen.ClassSelectionScreenHandler;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;

public class UpdateClassPacketReceiver
implements ServerPlayNetworking.PlayPayloadHandler<UpdateClassPacket> {
    public void receive(UpdateClassPacket payload, ServerPlayNetworking.Context context) {
        class_3222 player = context.player();
        class_1937 world = player.method_5770();
        class_1703 screenHandler = player.field_7512;
        if (screenHandler instanceof ClassSelectionScreenHandler) {
            Optional optionalRPGClassReference;
            ClassSelectionScreenHandler classSelectionScreenHandler = (ClassSelectionScreenHandler)screenHandler;
            class_1799 classItemStack = class_1799.field_8037;
            ClassStateComponent.ActiveClassState activeClassState = payload.newActiveClassState();
            String rpgClassIdentifierString = activeClassState.activeClassIdentifier();
            if (!rpgClassIdentifierString.isEmpty() && (optionalRPGClassReference = world.method_30349().method_30530(CustomDynamicRegistries.RPG_CLASS_REGISTRY_KEY).method_55841(class_2960.method_60654((String)rpgClassIdentifierString))).isPresent()) {
                RPGClass rpgClass = (RPGClass)((class_6880.class_6883)optionalRPGClassReference.get()).comp_349();
                Optional optionalItemReference = world.method_30349().method_30530(class_7924.field_41197).method_55841(class_2960.method_60654((String)rpgClass.class_item_identifier()));
                if (optionalItemReference.isPresent()) {
                    classItemStack = ((class_1792)((class_6880.class_6883)optionalItemReference.get()).comp_349()).method_7854();
                    ArrayList<String> spellIdentifiers = new ArrayList<String>();
                    ArrayList<class_9285.class_9287> attributeModifiers = new ArrayList<class_9285.class_9287>();
                    for (int i = 0; i < rpgClass.upgrade_entry_group_list().size(); ++i) {
                        RPGClass.UpgradeEntryGroup upgradeEntryGroup = rpgClass.upgrade_entry_group_list().get(i);
                        String activeUpgradeIdentifier = activeClassState.activeUpgradeIdentifierList().get(i);
                        if (activeUpgradeIdentifier.isEmpty()) continue;
                        for (int j = 0; j < upgradeEntryGroup.upgrade_entry_list().size(); ++j) {
                            RPGClass.UpgradeEntryGroup.UpgradeEntry upgradeEntry = upgradeEntryGroup.upgrade_entry_list().get(j);
                            if (!Objects.equals(upgradeEntry.upgrade_identifier(), activeUpgradeIdentifier)) continue;
                            for (RPGClass.UpgradeEntryGroup.UpgradeEntry.UpgradeEntryComponent component : upgradeEntry.component_list()) {
                                Optional optionalEntityAttributeReference;
                                if (Objects.equals(component.type(), RPGClass.UpgradeEntryGroup.UpgradeEntry.UpgradeEntryComponent.Type.SPELL.method_15434())) {
                                    String spellIdentifierString = component.spell_identifier();
                                    if (spellIdentifierString.isEmpty()) continue;
                                    spellIdentifiers.add(spellIdentifierString);
                                    continue;
                                }
                                if (!Objects.equals(component.type(), RPGClass.UpgradeEntryGroup.UpgradeEntry.UpgradeEntryComponent.Type.ATTRIBUTE_MODIFIER.method_15434()) || !(optionalEntityAttributeReference = world.method_30349().method_30530(class_7924.field_41251).method_55841(class_2960.method_60654((String)component.attribute_identifier()))).isPresent()) continue;
                                class_1322 entityAttributeModifier = null;
                                try {
                                    entityAttributeModifier = new class_1322(RPGClassSelection.identifier("upgrade_" + i), component.attribute_modifier_amount(), class_1322.class_1323.valueOf((String)component.attribute_modifier_operation()));
                                }
                                catch (IllegalArgumentException e) {
                                    RPGClassSelection.warn(e.getMessage());
                                }
                                if (entityAttributeModifier == null) continue;
                                attributeModifiers.add(new class_9285.class_9287((class_6880)optionalEntityAttributeReference.get(), entityAttributeModifier, RPGClassSelection.getClassItemAttributeModifierSlot()));
                            }
                        }
                    }
                    classItemStack.method_57379(SpellDataComponents.SPELL_CONTAINER, (Object)new SpellContainer(SpellContainer.ContentType.ANY, false, "", spellIdentifiers.size(), spellIdentifiers));
                    classItemStack.method_57379(class_9334.field_49636, (Object)new class_9285(attributeModifiers, true));
                    classItemStack.method_57379(RPGClassSelection.CLASS_STATE_COMPONENT_TYPE, (Object)new ClassStateComponent(activeClassState));
                }
            }
            RPGClassSelection.setClassItemStack((class_1657)player, classItemStack);
            player.method_7346();
        }
    }
}

