/*
 * Decompiled with CFR 0.152.
 */
package com.example.llamachat;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LlamaChatPlugin
extends JavaPlugin
implements Listener {
    private Map<UUID, String> chatHistory = new HashMap<UUID, String>();
    private String apiKey;
    private String chatPrefix;
    private int memoryResetInterval;

    public void onEnable() {
        this.saveDefaultConfig();
        this.apiKey = this.getConfig().getString("groq-api-key");
        this.chatPrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("chat.prefix", "&b[Llama]&r"));
        this.memoryResetInterval = this.getConfig().getInt("chat.memory-reset-interval", 2) * 1200;
        if (this.apiKey == null || this.apiKey.isEmpty() || this.apiKey.equals("your-api-key-here")) {
            this.getLogger().severe("No API key found! Please set 'groq-api-key' in config.yml");
            this.getLogger().severe("Disabling LlamaChat plugin...");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                LlamaChatPlugin.this.chatHistory.clear();
                LlamaChatPlugin.this.getLogger().info("Chat memory has been reset");
            }
        }.runTaskTimerAsynchronously((Plugin)this, (long)this.memoryResetInterval, (long)this.memoryResetInterval);
        this.getLogger().info("LlamaChat plugin enabled!");
    }

    public void onDisable() {
        this.getLogger().info("LlamaChat plugin disabled!");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        UUID playerUUID = player.getUniqueId();
        this.chatHistory.putIfAbsent(playerUUID, "");
        this.chatHistory.put(playerUUID, this.chatHistory.get(playerUUID) + "\n" + player.getName() + ": " + message);
        if (message.startsWith("/")) {
            return;
        }
        if (!message.toLowerCase().contains("llama")) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            final String response = this.getGroqResponse(player.getName(), message, this.chatHistory.get(playerUUID));
            if (response != null && !response.isEmpty()) {
                new BukkitRunnable(this){
                    final /* synthetic */ LlamaChatPlugin this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        Bukkit.broadcastMessage((String)(this.this$0.chatPrefix + " " + response));
                    }
                }.runTask((Plugin)this);
            }
        }).exceptionally(ex -> {
            this.getLogger().severe("Error getting AI response: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        });
    }

    private String getGroqResponse(String playerName, String message, String history) {
        try {
            String responseLine;
            BufferedReader br;
            URL url = new URL("https://api.groq.com/openai/v1/chat/completions");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Bearer " + this.apiKey);
            conn.setDoOutput(true);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            String prompt = "your an minecraft player called Llama how would u react to this message (react shortly no long texts not dramatic and just chill you only exist in the chat and you dont have a playermodel meaning u cant build eat or do any stuff)\n\nPLAYERMSG\n" + playerName + ": " + message;
            if (history != null && !history.isEmpty()) {
                prompt = "Here's some context of our conversation so far:\n" + history + "\n\n" + prompt;
            }
            JsonObject messageObj = new JsonObject();
            messageObj.addProperty("role", "user");
            messageObj.addProperty("content", prompt);
            JsonObject requestBody = new JsonObject();
            requestBody.add("messages", JsonParser.parseString("[" + messageObj.toString() + "]"));
            requestBody.addProperty("model", "meta-llama/llama-4-scout-17b-16e-instruct");
            requestBody.addProperty("temperature", 1);
            requestBody.addProperty("max_completion_tokens", 1024);
            requestBody.addProperty("top_p", 1);
            requestBody.addProperty("stream", false);
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = requestBody.toString().getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String responseLine2;
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
                StringBuilder response = new StringBuilder();
                while ((responseLine2 = br.readLine()) != null) {
                    response.append(responseLine2.trim());
                }
                JsonObject jsonResponse = JsonParser.parseString(response.toString()).getAsJsonObject();
                String content = jsonResponse.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
                return content;
            }
            this.getLogger().warning("API request failed with code: " + responseCode);
            br = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            StringBuilder response = new StringBuilder();
            while ((responseLine = br.readLine()) != null) {
                response.append(responseLine.trim());
            }
            this.getLogger().warning("Error response: " + response.toString());
            return null;
        }
        catch (IOException e) {
            this.getLogger().severe("Error communicating with API: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

