/*
 * Decompiled with CFR 0.152.
 */
package cn.ksmcbrigade.cser.mixin;

import cn.ksmcbrigade.cser.Constants;
import cn.ksmcbrigade.cser.interfaces.IChatComp;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public class ChatCompMixin
implements IChatComp {
    @Mutable
    @Shadow
    @Final
    private List<GuiMessage.Line> trimmedMessages;
    @Shadow
    @Final
    private List<GuiMessage> allMessages;
    @Unique
    private String chatSearcher$searchWords = "";
    @Unique
    private List<GuiMessage.Line> chatSearcher$searchedMessages = Lists.newArrayList();
    @Unique
    private List<GuiMessage.Line> chatSearcher$orMessages = Lists.newArrayList();

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Ljava/util/List;size()I", ordinal=0, shift=At.Shift.BEFORE)})
    private void render(GuiGraphics pGuiGraphics, int pTickCount, int pMouseX, int pMouseY, boolean pFocused, CallbackInfo ci) {
        this.chatSearcher$orMessages = new ArrayList<GuiMessage.Line>(this.trimmedMessages);
        if (this.chatSearcher$searchWords.isEmpty() || !(Minecraft.getInstance().screen instanceof ChatScreen)) {
            this.chatSearcher$searchWords = "";
            return;
        }
        this.chatSearcher$searchedMessages.clear();
        for (GuiMessage message : this.allMessages) {
            GuiMessage.Line line;
            String s = message.content().getString();
            if (Constants.CONFIG.value) {
                s = s.toLowerCase();
                this.chatSearcher$searchWords = this.chatSearcher$searchWords.toLowerCase();
            }
            if (!s.contains(this.chatSearcher$searchWords) || (line = this.chatSearcher$getMessage(message)) == null) continue;
            this.chatSearcher$searchedMessages.add(line);
        }
        if (!this.chatSearcher$searchedMessages.isEmpty()) {
            this.trimmedMessages = this.chatSearcher$searchedMessages;
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void rendered(GuiGraphics pGuiGraphics, int pTickCount, int pMouseX, int pMouseY, boolean pFocused, CallbackInfo ci) {
        if (!this.chatSearcher$orMessages.isEmpty()) {
            this.trimmedMessages = this.chatSearcher$orMessages;
        }
    }

    @Unique
    private GuiMessage.Line chatSearcher$getMessage(GuiMessage message) {
        for (GuiMessage.Line trimmedMessage : this.trimmedMessages) {
            if (trimmedMessage.addedTime() != message.addedTime()) continue;
            return trimmedMessage;
        }
        return null;
    }

    @Override
    public void chatSearcher$setWords(String words) {
        this.chatSearcher$searchWords = words;
    }
}

