/*
 * Decompiled with CFR 0.152.
 */
package cn.ksmcbrigade.cser.mixin;

import cn.ksmcbrigade.cser.CommonClass;
import cn.ksmcbrigade.cser.interfaces.IChatComp;
import cn.ksmcbrigade.cser.interfaces.IChatScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public abstract class ChatScreenMixin
extends Screen
implements IChatScreen {
    @Shadow
    protected EditBox input;
    @Unique
    private EditBox chatSearcher$editBox;

    protected ChatScreenMixin(Component pTitle) {
        super(pTitle);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(String pInitial, CallbackInfo ci) {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.getInstance();
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        this.input.setCanLoseFocus(true);
        this.chatSearcher$editBox = new EditBox(Minecraft.getInstance().font, 80, 20, (Component)Component.literal((String)"SearchBox"));
        this.chatSearcher$editBox.setHint((Component)Component.literal((String)"Search..."));
        this.chatSearcher$editBox.setValue(CommonClass.searchWords);
        this.chatSearcher$editBox.setMaxLength(1024);
        this.chatSearcher$editBox.setPosition(this.width - this.chatSearcher$editBox.getWidth() - 2, this.height - this.chatSearcher$editBox.getHeight() - this.input.getHeight() - 4);
        this.chatSearcher$editBox.setEditable(true);
        this.chatSearcher$editBox.setCanLoseFocus(true);
        this.chatSearcher$editBox.setFocused(false);
        this.chatSearcher$editBox.setResponder(s -> ((IChatComp)Minecraft.getInstance().gui.getChat()).chatSearcher$setWords((String)s));
        this.addRenderableWidget((GuiEventListener)this.chatSearcher$editBox);
        CommonClass.searchWords = "";
    }

    @Inject(method={"render", "init"}, at={@At(value="HEAD")})
    public void fix(CallbackInfo ci) {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.getInstance();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")})
    public void fix2(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.minecraft == null) {
            this.minecraft = Minecraft.getInstance();
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen;handleChatInput(Ljava/lang/String;Z)V", shift=At.Shift.BEFORE)}, cancellable=true)
    public void notClose(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!this.input.isFocused()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public void chatSearcher$reset() {
        if (this.chatSearcher$editBox != null) {
            CommonClass.searchWords = this.chatSearcher$editBox.getValue();
        }
        Minecraft.getInstance().setScreen((Screen)new ChatScreen(this.input.getValue()));
    }
}

