package ws.siri.jscore.behaviour.command;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;

import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import ws.siri.jscore.behaviour.Snapshot;

class ListSuggestionProvider implements SuggestionProvider<FabricClientCommandSource> {

    @Override
    public CompletableFuture<Suggestions> getSuggestions(CommandContext<FabricClientCommandSource> context,
            SuggestionsBuilder builder) throws CommandSyntaxException {
        List<String> snapshots = Snapshot.list();
        for (String snapshot : snapshots) {
            builder.suggest(snapshot);
        }

        return builder.buildFuture();
    }

}

public class SnapshotCommand {
    public static ListSuggestionProvider listProvider() {
        return new ListSuggestionProvider();
    }

    public static int snapNamed(CommandContext<FabricClientCommandSource> context) {
        CompletableFuture.runAsync(() -> {
            try {
                String name = context.getArgument("name", String.class);

                if (name.endsWith(".zip")) {
                    name = name.substring(0, name.length() - 4);
                }

                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("> Creating snapshot").method_27692(class_124.field_1060));

                Snapshot.snap(name);

                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(
                                    class_2561.method_43470(String.format("Snapshot saved to %s.zip", name))
                                            .method_27692(class_124.field_1054));
            } catch (Exception e) {
                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("An error has occured when creating snapshot:\n")
                                    .method_27693(e.toString()).method_27692(class_124.field_1061));
            }
        });
        return 0;
    }

    public static int snap(CommandContext<FabricClientCommandSource> context) {
        CompletableFuture.runAsync(() -> {
            try {
                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("> Creating snapshot").method_27692(class_124.field_1060));

                String res = Snapshot.snap();

                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(
                                    class_2561.method_43470(String.format("Snapshot saved to %s", res))
                                            .method_27692(class_124.field_1054));
            } catch (Exception e) {
                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("An error has occured when creating snapshot:\n")
                                    .method_27693(e.toString()).method_27692(class_124.field_1061));
            }
        });
        return 0;
    }

    public static int restore(CommandContext<FabricClientCommandSource> context) {
        CompletableFuture.runAsync(() -> {
            try {
                String fileName = context.getArgument("file", String.class);

                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("> Loading snapshot " + fileName).method_27692(class_124.field_1060));

                boolean loaded = Snapshot.load(fileName);

                if (loaded) {
                    if (class_310.method_1551().field_1724 != null)
                        class_310.method_1551().field_1705.method_1743()
                                .method_1812(
                                        class_2561.method_43470("Snapshot restored")
                                                .method_27692(class_124.field_1054));
                } else {
                    if (class_310.method_1551().field_1724 != null)
                        class_310.method_1551().field_1705.method_1743()
                                .method_1812(
                                        class_2561.method_43470("Snapshot not restored: not snapshot with that name")
                                                .method_27692(class_124.field_1061));
                }
            } catch (Exception e) {
                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("An error has occured when creating snapshot:\n")
                                    .method_27693(e.toString()).method_27692(class_124.field_1061));
            }
        });
        return 0;
    }

    public static int pull(CommandContext<FabricClientCommandSource> context) {
        CompletableFuture.runAsync(() -> {
            try {
                String url = context.getArgument("url", String.class);

                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("> Pulling snapshot").method_27692(class_124.field_1060));

                Snapshot.pull(url);

                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(
                                    class_2561.method_43470("Snapshot pulled")
                                            .method_27692(class_124.field_1054));
            } catch (Exception e) {
                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("An error has occured when pulling snapshot:\n")
                                    .method_27693(e.toString()).method_27692(class_124.field_1061));
            }
        });
        return 0;
    }

    public static int delete(CommandContext<FabricClientCommandSource> context) {
        CompletableFuture.runAsync(() -> {
            try {
                String name = context.getArgument("file", String.class);

                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("> Deleting snapshot " + name).method_27692(class_124.field_1060));

                if (Snapshot.delete(name)) {
                    if (class_310.method_1551().field_1724 != null)
                        class_310.method_1551().field_1705.method_1743()
                                .method_1812(
                                        class_2561.method_43470("Snapshot deleted")
                                                .method_27692(class_124.field_1054));
                } else {
                    if (class_310.method_1551().field_1724 != null)
                        class_310.method_1551().field_1705.method_1743()
                                .method_1812(
                                        class_2561.method_43470("Nothing deleted, snapshot does not exist")
                                                .method_27692(class_124.field_1054));
                }

            } catch (Exception e) {
                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("An error has occured when deleting snapshot:\n")
                                    .method_27693(e.toString()).method_27692(class_124.field_1061));
            }
        });
        return 0;
    }
}
