/*
 * Decompiled with CFR 0.152.
 */
package ws.siri.jscore.runtime;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;
import ws.siri.jscore.mapping.JSClass;
import ws.siri.jscore.mapping.JSFunction;
import ws.siri.jscore.mapping.JSObject;
import ws.siri.jscore.mapping.JSPackage;
import ws.siri.jscore.runtime.Module;
import ws.siri.yarnwrap.mapping.JavaClass;
import ws.siri.yarnwrap.mapping.JavaFunction;
import ws.siri.yarnwrap.mapping.JavaLike;
import ws.siri.yarnwrap.mapping.JavaObject;
import ws.siri.yarnwrap.mapping.JavaPackage;

public class Runtime {
    public static Object global = Runtime.newGlobal();
    private static HashMap<List<String>, Module> modules = new HashMap();
    private static Optional<String> gotPrelude;

    private static ScriptableObject newGlobal() {
        return new ScriptableObject(){

            public String getClassName() {
                return "org.mozilla.javascript.ScriptableObject";
            }
        };
    }

    public static void init() {
        gotPrelude = Runtime.getPreludeInternal();
        Path entryPoint = FabricLoader.getInstance().getConfigDir().resolve("jscore");
        if (Files.exists(entryPoint.resolve("init.js"), new LinkOption[0]) || Files.exists(entryPoint.resolve("init").resolve("index.js"), new LinkOption[0])) {
            Runtime.call(Path.of("init", new String[0]), "lazy", null);
        }
    }

    public static Set<List<String>> listLoaded() {
        return modules.keySet();
    }

    public static boolean unload(List<String> path) {
        return modules.remove(path) != null;
    }

    public static void stop() {
        Path entryPoint = FabricLoader.getInstance().getConfigDir().resolve("jscore");
        if (Files.exists(entryPoint.resolve("stop.js"), new LinkOption[0]) || Files.exists(entryPoint.resolve("stop").resolve("index.js"), new LinkOption[0])) {
            Runtime.call(Path.of("stop", new String[0]), "lazy", null);
        }
        modules = new HashMap();
    }

    public static Object evaluate(String expr, List<String> path, boolean isLazy) {
        return Runtime.getModule(path).evaluate(expr, isLazy);
    }

    public static Optional<String> getPrelude() {
        return gotPrelude;
    }

    private static Optional<String> getPreludeInternal() {
        Path basePath = FabricLoader.getInstance().getConfigDir().resolve("jscore");
        if (Files.exists(basePath.resolve("prelude.js"), new LinkOption[0])) {
            try {
                return Optional.of(Files.readString(basePath.resolve("prelude.js")));
            }
            catch (IOException e) {
                throw new RuntimeException("Error getting prelude: " + String.valueOf(e));
            }
        }
        if (Files.exists(basePath.resolve("prelude").resolve("index.js"), new LinkOption[0])) {
            try {
                return Optional.of(Files.readString(basePath.resolve("prelude").resolve("index.js")));
            }
            catch (IOException e) {
                throw new RuntimeException("Error getting prelude: " + String.valueOf(e));
            }
        }
        return Optional.empty();
    }

    public static Object asJS(Object source) {
        if (source instanceof JavaLike) {
            if (source instanceof JavaObject) {
                return new JSObject((JavaObject)source);
            }
            if (source instanceof JavaClass) {
                return new JSClass((JavaClass)source);
            }
            if (source instanceof JavaFunction) {
                return new JSFunction((JavaFunction)source);
            }
            if (source instanceof JavaPackage) {
                return new JSPackage((JavaPackage)source);
            }
        }
        return source;
    }

    public static Object unwrap(Object source) {
        if (source instanceof JSObject) {
            return ((JSObject)((Object)source)).internal.internal;
        }
        if (source instanceof JavaObject) {
            return ((JSFunction)((Object)source)).internal;
        }
        if (source instanceof JSClass) {
            return ((JSClass)((Object)source)).internal;
        }
        if (source instanceof JSPackage) {
            return ((JSPackage)((Object)source)).internal;
        }
        return source;
    }

    public static Object wrap(Object source) {
        if (!(source instanceof JavaLike)) {
            source = new JavaObject(source);
        }
        if (source instanceof JavaObject) {
            return new JSObject((JavaObject)source);
        }
        if (source instanceof JavaClass) {
            return new JSClass((JavaClass)source);
        }
        if (source instanceof JavaFunction) {
            return new JSFunction((JavaFunction)source);
        }
        if (source instanceof JavaPackage) {
            return new JSPackage((JavaPackage)source);
        }
        throw new RuntimeException(String.format("Could not wrap %s is not of any JavaLike", source));
    }

    public static Object autoWrap(Object source) {
        if (source instanceof ScriptableObject) {
            return source;
        }
        return Runtime.asJS(JavaObject.autoWrap((Object)source));
    }

    public static Module getModule(List<String> path) {
        if (!modules.containsKey(path)) {
            modules.put(path, new Module(path));
        }
        return modules.get(path);
    }

    @Nullable
    public static Object call(Path path, String mode, String content) {
        return Runtime.call(path, mode, content, !mode.equals("strict"));
    }

    private static List<String> pathToList(Path path) {
        ArrayList<String> out = new ArrayList<String>();
        for (Path chunk : path) {
            out.add(chunk.toString());
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Object call(Path path, String mode, String content, boolean isLazy) {
        path = Module.normalisePath(path);
        switch (mode) {
            case "lazy": {
                List<String> pathList = Runtime.pathToList(path);
                if (modules.containsKey(pathList)) return Runtime.modules.get(pathList).exports;
                ArrayList<String> pathWithExtension = new ArrayList<String>(pathList);
                pathWithExtension.set(pathWithExtension.size() - 1, (String)pathWithExtension.getLast() + ".js");
                if (modules.containsKey(pathWithExtension)) {
                    pathList = pathWithExtension;
                    return Runtime.modules.get(pathList).exports;
                } else {
                    ArrayList<String> pathWithIndexJs = new ArrayList<String>(pathList);
                    pathWithIndexJs.add("index.js");
                    if (!modules.containsKey(pathWithIndexJs)) return Runtime.call(path, "strict", content, true);
                    pathList = pathWithIndexJs;
                }
                return Runtime.modules.get(pathList).exports;
            }
            case "strict": {
                Path basePath = FabricLoader.getInstance().getConfigDir().resolve("jscore");
                if (!Files.exists(basePath.resolve(path), new LinkOption[0])) {
                    if (path.getFileName().endsWith(".js")) throw new RuntimeException("Could not find file at " + path.toString() + ".js");
                    newPath = path.resolveSibling(String.valueOf(path.getFileName()) + ".js");
                    if (!Files.exists(basePath.resolve(newPath), new LinkOption[0])) throw new RuntimeException("Could not find file at " + newPath.toString());
                    path = newPath;
                } else if (Files.isDirectory(basePath.resolve(path), new LinkOption[0])) {
                    newPath = path.resolve("index.js");
                    if (!Files.exists(basePath.resolve(newPath), new LinkOption[0])) throw new RuntimeException("Could not find file at " + newPath.toString());
                    path = newPath;
                }
                try {
                    content = Files.readString(basePath.resolve(path));
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Error reading file %s: %s", path, e));
                }
                List<String> pathList = Runtime.pathToList(path);
                Runtime.evaluate(content, pathList, isLazy);
                return Runtime.modules.get(pathList).exports;
            }
            case "append": {
                List<String> pathList = Runtime.pathToList(path);
                if (!modules.containsKey(pathList)) {
                    ArrayList<String> pathWithExtension = new ArrayList<String>(pathList);
                    pathWithExtension.set(pathWithExtension.size() - 1, (String)pathWithExtension.getLast() + ".js");
                    if (modules.containsKey(pathWithExtension)) {
                        pathList = pathWithExtension;
                    } else {
                        ArrayList<String> pathWithIndexJs = new ArrayList<String>(pathList);
                        pathWithIndexJs.add("index.js");
                        if (!modules.containsKey(pathWithIndexJs)) throw new RuntimeException("Cannot find module with name: " + String.valueOf(path));
                        pathList = pathWithIndexJs;
                    }
                }
                Module module = modules.get(pathList);
                module.evaluate(content, isLazy);
            }
        }
        throw new UnsupportedOperationException("No require mode '" + mode + "'");
    }

    public static Context getContext() {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            cx = Context.enter();
        }
        return cx;
    }
}

