package ws.siri.jscore.behaviour.command;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;

import com.mojang.brigadier.context.CommandContext;

import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import ws.siri.jscore.runtime.Runtime;

/**
 * Require [strict/lazy] &lt;path&gt;
 * 
 * - strict always loads the file
 * - lazy only loads the file if not previously loaded
 */
public class RequireCommand {
    public static int lazy(CommandContext<FabricClientCommandSource> context) {
        String path = context.getArgument("path", String.class);
        run(path, "lazy");
        return 0;
    }

    public static int strict(CommandContext<FabricClientCommandSource> context) {
        String path = context.getArgument("path", String.class);
        run(path, "strict");
        return 0;
    }

    private static void run(String path, String mode) {
        CompletableFuture.runAsync(() -> {
            try {
                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(
                                    class_2561.method_43470(String.format("Run %s (%s)", path, mode)).method_27692(class_124.field_1060));

                Path filePath = Path.of(path).normalize();

                if (filePath.isAbsolute()) {
                    filePath = filePath.subpath(0, filePath.getNameCount());
                }
                Object res = Runtime.call(filePath, mode, null);

                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(
                                    class_2561.method_43470(res == null ? "null" : res.toString()).method_27692(class_124.field_1054));
            } catch (Exception e) {
                if (class_310.method_1551().field_1724 != null)
                    class_310.method_1551().field_1705.method_1743()
                            .method_1812(class_2561.method_43470("An error has occured when running this script:\n")
                                    .method_27693(e.toString()).method_27692(class_124.field_1061));
            }
        });
    }
}
