/*
 * Decompiled with CFR 0.152.
 */
package ws.siri.jscore.behaviour;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;

public class Snapshot {
    private static HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();

    public static String snap() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        String formattedTime = now.format(formatter);
        Snapshot.snap(formattedTime);
        return formattedTime + ".zip";
    }

    public static boolean snap(String name) {
        Path source = FabricLoader.getInstance().getConfigDir().resolve("jscore");
        Path target = FabricLoader.getInstance().getConfigDir().resolve("jscore-snapshots").resolve(name + ".zip");
        Snapshot.setupDir();
        boolean overwrite = Files.exists(target, new LinkOption[0]);
        try {
            if (overwrite) {
                FileUtils.deleteQuietly((File)target.toFile());
            }
            FileOutputStream fos = new FileOutputStream(target.toFile());
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            File fileToZip = source.toFile();
            Snapshot.zipFile(fileToZip, fileToZip.getName(), zipOut);
            zipOut.close();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating snapshot: " + String.valueOf(e));
        }
        return overwrite;
    }

    public static boolean load(String fileName) {
        Path snapshotPath = FabricLoader.getInstance().getConfigDir().resolve("jscore-snapshots").resolve(fileName);
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("jscore");
        if (!Files.exists(snapshotPath, new LinkOption[0])) {
            return false;
        }
        if (Files.isDirectory(snapshotPath, new LinkOption[0])) {
            try {
                if (Files.exists(configPath, new LinkOption[0])) {
                    FileUtils.deleteQuietly((File)configPath.toFile());
                }
                Files.move(snapshotPath, configPath, new CopyOption[0]);
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException("Error when loading snapshot " + fileName + ": " + String.valueOf(e));
            }
        }
        Path tempConfigPath = FabricLoader.getInstance().getConfigDir().resolve("jscore-restoring");
        try {
            if (Files.exists(tempConfigPath, new LinkOption[0])) {
                FileUtils.deleteQuietly((File)tempConfigPath.toFile());
            }
            Files.createDirectories(tempConfigPath, new FileAttribute[0]);
            FileInputStream is = new FileInputStream(snapshotPath.toFile());
            Snapshot.unzip(is, tempConfigPath);
            if (Files.exists(configPath, new LinkOption[0])) {
                FileUtils.deleteQuietly((File)configPath.toFile());
            }
            if (Files.list(tempConfigPath).count() == 1L && Files.exists(tempConfigPath.resolve("jscore"), new LinkOption[0])) {
                Files.move(tempConfigPath.resolve("jscore"), configPath, new CopyOption[0]);
            } else {
                Files.move(tempConfigPath, configPath, new CopyOption[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error when loading snapshot " + fileName + ": " + String.valueOf(e));
        }
        finally {
            if (Files.exists(tempConfigPath, new LinkOption[0])) {
                FileUtils.deleteQuietly((File)tempConfigPath.toFile());
            }
        }
        return true;
    }

    private static void unzip(InputStream is, Path targetDir) throws IOException {
        targetDir = targetDir.toAbsolutePath();
        try (ZipInputStream zipIn = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zipIn.getNextEntry()) != null) {
                Path resolvedPath = targetDir.resolve(ze.getName()).normalize();
                if (!resolvedPath.startsWith(targetDir)) {
                    throw new RuntimeException("Entry with an illegal path: " + ze.getName());
                }
                if (ze.isDirectory()) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                Files.copy(zipIn, resolvedPath, new CopyOption[0]);
            }
        }
    }

    public static List<String> list() {
        try {
            Snapshot.setupDir();
            return Files.list(FabricLoader.getInstance().getConfigDir().resolve("jscore-snapshots")).map(path -> path.getFileName().toString()).toList();
        }
        catch (IOException e) {
            throw new RuntimeException("Error listings snapshots: " + String.valueOf(e));
        }
    }

    private static void setupDir() {
        FabricLoader.getInstance().getConfigDir().resolve("jscore-snapshots").toFile().mkdirs();
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                Snapshot.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    public static boolean delete(String name) {
        Path filePath = FabricLoader.getInstance().getConfigDir().resolve("jscore-snapshots").resolve(name);
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                Files.delete(filePath);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when deleting file " + name + ": " + String.valueOf(e));
            }
            return true;
        }
        return false;
    }

    public static void pull(String url) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        Path configPath = FabricLoader.getInstance().getConfigDir().resolve("jscore");
        Path tempConfigPath = FabricLoader.getInstance().getConfigDir().resolve("jscore-pulling");
        try {
            InputStream is = client.send(request, HttpResponse.BodyHandlers.ofInputStream()).body();
            if (Files.exists(tempConfigPath, new LinkOption[0])) {
                FileUtils.deleteQuietly((File)tempConfigPath.toFile());
            }
            Files.createDirectories(tempConfigPath, new FileAttribute[0]);
            Snapshot.unzip(is, tempConfigPath);
            if (Files.exists(configPath, new LinkOption[0])) {
                FileUtils.deleteQuietly((File)configPath.toFile());
            }
            if (Files.list(tempConfigPath).count() == 1L && Files.exists(tempConfigPath.resolve("jscore"), new LinkOption[0])) {
                Files.move(tempConfigPath.resolve("jscore"), configPath, new CopyOption[0]);
            } else {
                Files.move(tempConfigPath, configPath, new CopyOption[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error when pulling snapshot: " + String.valueOf(e));
        }
        finally {
            if (Files.exists(tempConfigPath, new LinkOption[0])) {
                FileUtils.deleteQuietly((File)tempConfigPath.toFile());
            }
        }
    }
}

