/*
 * Decompiled with CFR 0.152.
 */
package ws.siri.jscore.runtime;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import ws.siri.jscore.mapping.JSFunction;
import ws.siri.jscore.mapping.JSObject;
import ws.siri.jscore.runtime.Runtime;
import ws.siri.yarnwrap.mapping.JavaObject;

public class Module
extends ScriptableObject {
    private Scriptable scope;
    public Object exports = Undefined.instance;
    public JSFunction require = (JSFunction)((Object)new JSObject(new JavaObject((Object)new Require())).get("call", null));
    public JSFunction eval = (JSFunction)((Object)new JSObject(new JavaObject((Object)this)).get("evaluateSimple", null));
    public JSFunction evalFile = (JSFunction)((Object)new JSObject(new JavaObject((Object)this)).get("evaluateFile", null));
    public JSFunction applyPrelude = (JSFunction)((Object)new JSObject(new JavaObject((Object)this)).get("appendPrelude", null));
    private boolean isLazy;
    private final List<String> path;

    public Module(List<String> path) {
        this.scope = Runtime.getContext().initStandardObjects();
        this.scope.put("module", this.scope, (Object)this);
        this.path = path;
        this.appendPrelude();
    }

    public void appendPrelude() {
        Optional<String> prelude = Runtime.getPrelude();
        if (prelude.isPresent()) {
            this.evaluateFile(prelude.get(), "prelude");
        }
    }

    public Object evaluateFile(String content, String name) {
        return this.evaluate(content, true, Optional.of(name));
    }

    public Object evaluateSimple(String expr) {
        return this.evaluate(expr);
    }

    public Object evaluate(String expr) {
        return this.evaluate(expr, true);
    }

    public Object evaluate(String expr, boolean isLazy) {
        return this.evaluate(expr, isLazy, Optional.empty());
    }

    private Object evaluate(String expr, boolean isLazy, Optional<String> preludeName) {
        this.isLazy = isLazy;
        Object res = Runtime.getContext().evaluateString(this.scope, expr, String.join((CharSequence)"/", this.path) + (String)(preludeName.isPresent() ? "(prelude: " + preludeName.get() + ")" : ""), 1, null);
        return Context.jsToJava((Object)res, Object.class);
    }

    public String getClassName() {
        return String.format("JSScope(%s)", String.join((CharSequence)".", this.path));
    }

    public Object get(String name, Scriptable start) {
        switch (name) {
            case "exports": {
                if (this.exports == null) {
                    return NOT_FOUND;
                }
                return this.exports;
            }
            case "require": {
                return this.require;
            }
            case "path": {
                return this.path;
            }
            case "globals": {
                return Runtime.global;
            }
            case "eval": {
                return this.eval;
            }
            case "evalFile": {
                return this.evalFile;
            }
            case "applyPrelude": {
                return this.applyPrelude;
            }
        }
        return NOT_FOUND;
    }

    public void put(String name, Scriptable start, Object value) {
        switch (name) {
            case "exports": {
                this.exports = value;
                break;
            }
            case "globals": {
                Runtime.global = value;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Cannot change value of module.%s", name));
            }
        }
    }

    public boolean has(String name, Scriptable start) {
        switch (name) {
            case "exports": {
                return this.exports != null;
            }
            case "eval": 
            case "evalFile": 
            case "require": 
            case "path": 
            case "globals": 
            case "applyPrelude": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Object exports() {
        return this.exports;
    }

    public static Path normalisePath(Path path) {
        if ((path = path.normalize()).isAbsolute() || path.toString().startsWith("\\")) {
            path = path.subpath(0, path.getNameCount());
        }
        while (path.getNameCount() > 0 && path.getName(0).toString().equals("..")) {
            path = path.subpath(1, path.getNameCount());
        }
        return path;
    }

    public class Require {
        private Path getRelativePath(String relativePath) {
            return Module.normalisePath(Path.of(String.join((CharSequence)"/", Module.this.path), new String[0]).resolveSibling(relativePath));
        }

        public Object call(String relativePath, String mode, String content) {
            return Runtime.call(this.getRelativePath(relativePath), mode, content);
        }

        public Object call(String relativePath, String mode) {
            return Runtime.call(this.getRelativePath(relativePath), mode, null);
        }

        public Object call(String relativePath) {
            return Runtime.call(this.getRelativePath(relativePath), Module.this.isLazy ? "lazy" : "strict", null);
        }
    }
}

