/*
 * Decompiled with CFR 0.152.
 */
package com.zac.features;

import com.zac.Config;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber
public class CustomZombieDrops {
    private static void spawnDrops(ServerLevel world, double x, double y, double z, ItemStack itemStack) {
        ItemEntity entityToSpawn = new ItemEntity((Level)world, x, y, z, itemStack);
        entityToSpawn.setPickUpDelay(10);
        world.addFreshEntity((Entity)entityToSpawn);
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDropsEvent event) {
        Level level;
        LivingEntity entity;
        if (!Config.additionalZombieDrops.isEmpty() && (entity = event.getEntity()) != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            double x = entity.getX();
            double y = entity.getY();
            double z = entity.getZ();
            if (entity instanceof Zombie) {
                ArrayList<String> drops = new ArrayList<String>(Config.additionalZombieDrops);
                for (String drop : drops) {
                    String[] splitDrop = drop.trim().split("=");
                    Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)splitDrop[0].toLowerCase()));
                    double chance = Double.parseDouble(splitDrop[1]);
                    if (!(Math.random() < chance)) continue;
                    CustomZombieDrops.spawnDrops(world, x, y, z, new ItemStack((ItemLike)item));
                }
            }
        }
    }
}

