/*
 * Decompiled with CFR 0.152.
 */
package com.zac.goals.BlockBreakGoal;

import com.zac.Config;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockBreakGoal
extends Goal {
    private final Zombie zombie;

    public BlockBreakGoal(Zombie zombie) {
        this.zombie = zombie;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        return true;
    }

    public void tick() {
        BlockState blockState;
        Player player;
        BlockPos blockPos;
        super.tick();
        LivingEntity target = this.zombie.getTarget();
        Level level = this.zombie.level();
        if (target instanceof Player && (blockPos = BlockBreakGoal.getClosestBlock((LivingEntity)this.zombie, (LivingEntity)(player = (Player)target))) != null && (blockState = level.getBlockState(blockPos)).getDestroySpeed((BlockGetter)level, blockPos) > (float)Config.blockMinimumHardness && blockState.getDestroySpeed((BlockGetter)level, blockPos) <= (float)Config.blockMaximumHardness) {
            Vec3 entityPos = this.zombie.position();
            Vec3 blockCenter = Vec3.atCenterOf((Vec3i)blockPos);
            double dist = entityPos.distanceToSqr(blockCenter);
            if (!level.isClientSide && dist <= (double)(Config.zombieBlockBreakReach * Config.zombieBlockBreakReach)) {
                level.destroyBlock(blockPos, true);
            }
        }
    }

    public static BlockPos getClosestBlock(LivingEntity entityOne, LivingEntity entityTwo) {
        Vec3 from = entityOne.getEyePosition(1.0f);
        Vec3 to = entityTwo.position();
        to = to.add(0.0, 0.5, 0.0);
        BlockPos blockpos = null;
        ClipContext clipcontext = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entityOne);
        BlockHitResult blockhits = entityOne.level().clip(clipcontext);
        if (blockhits.getType() == HitResult.Type.BLOCK) {
            blockpos = blockhits.getBlockPos();
        }
        return blockpos;
    }
}

