/*
 * Decompiled with CFR 0.152.
 */
package com.zac.features;

import com.zac.Config;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CustomZombieDrops {
    private static void spawnDrops(ServerLevel world, double x, double y, double z, ItemStack itemStack) {
        ItemEntity entityToSpawn = new ItemEntity((Level)world, x, y, z, itemStack);
        entityToSpawn.m_32010_(10);
        world.m_7967_((Entity)entityToSpawn);
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Level level;
        LivingEntity entity;
        if (!Config.additionalZombieDrops.isEmpty() && (entity = event.getEntity()) != null && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            if (entity instanceof Zombie) {
                ArrayList<String> drops = new ArrayList<String>(Config.additionalZombieDrops);
                for (String drop : drops) {
                    String[] splitDrop = drop.trim().split("=");
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.parse((String)splitDrop[0].toLowerCase()));
                    double chance = Double.parseDouble(splitDrop[1]);
                    if (!(Math.random() < chance)) continue;
                    CustomZombieDrops.spawnDrops(world, x, y, z, new ItemStack((ItemLike)item));
                }
            }
        }
    }
}

