/*
 * Decompiled with CFR 0.152.
 */
package com.zac.features;

import com.zac.Config;
import com.zac.WorldData;
import com.zac.ZombieApocalypseCore;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DayCounter {
    private static String[] messages = new String[]{"-", "--", "- -", "- D -", "- DA -", "- DAY -", "- DAY X -"};
    private static final HashMap<UUID, Integer> time = new HashMap();

    public static void playSoundAndSendMsg(Player player, String msg) {
        SoundEvent sound = SoundEvents.f_12444_;
        BlockPos blockpos = BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_());
        player.m_9236_().m_5594_(null, blockpos, sound, SoundSource.NEUTRAL, 3.0f, 3.0f);
        player.m_5661_((Component)Component.m_237113_((String)msg), true);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (Config.dayCounterEnabled) {
            Level world;
            Player player = event.player;
            if (event.phase == TickEvent.Phase.END && player != null && !(world = player.m_9236_()).m_5776_() && world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                if (world.m_8044_() % 24000L == 1L) {
                    WorldData data = WorldData.get(level);
                    int day = data.getDay() + 1;
                    data.setDay(day);
                    UUID playerUUID = player.m_20148_();
                    time.put(playerUUID, 0);
                    int savedTime = time.get(playerUUID);
                    for (String message : messages) {
                        time.put(playerUUID, savedTime += 10);
                        ZombieApocalypseCore.queueServerWork(savedTime, () -> DayCounter.playSoundAndSendMsg(player, message.replace("X", String.valueOf(day))));
                    }
                    time.put(player.m_20148_(), 0);
                }
            }
        }
    }
}

