/*
 * Decompiled with CFR 0.152.
 */
package com.zac;

import com.zac.ConfigActions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;

public class Config {
    public static int entityMultiplierRate;
    public static List<String> entityMultiplierEntities;
    public static List<String> entityBlocklistEntities;
    public static List<String> daylightResistantEntities;
    public static List<String> additionalZombieDrops;
    public static boolean heavilyArmoredZombiesEnabled;
    public static boolean dayCounterEnabled;
    public static int blockMinimumHardness;
    public static int blockMaximumHardness;
    public static int zombieBlockBreakReach;
    public static boolean zombiesBreakBlocks;
    private static final Map<String, Object> defaults;
    private static final Map<String, String> comments;

    public static void init(String configPath) {
        ConfigActions.init(configPath, defaults, comments);
        entityMultiplierRate = ConfigActions.readInt("entityMultiplierRate");
        entityMultiplierEntities = ConfigActions.readList("entityMultiplierEntities");
        entityBlocklistEntities = ConfigActions.readList("entityBlocklistEntities");
        daylightResistantEntities = ConfigActions.readList("daylightResistantEntities");
        additionalZombieDrops = ConfigActions.readList("additionalZombieDrops");
        heavilyArmoredZombiesEnabled = ConfigActions.readBool("heavilyArmoredZombiesEnabled");
        dayCounterEnabled = ConfigActions.readBool("dayCounterEnabled");
        zombiesBreakBlocks = ConfigActions.readBool("zombiesBreakBlocks");
        zombieBlockBreakReach = ConfigActions.readInt("zombieBlockBreakReach");
        blockMinimumHardness = ConfigActions.readInt("blockMinimumHardness");
        blockMaximumHardness = ConfigActions.readInt("blockMaximumHardness");
    }

    public static void onServerStopping(MinecraftServer server) {
        ConfigActions.close();
    }

    static {
        defaults = new LinkedHashMap<String, Object>(){
            {
                this.put("entityMultiplierRate", 1);
                this.put("entityMultiplierEntities", List.of());
                this.put("entityBlocklistEntities", List.of());
                this.put("daylightResistantEntities", List.of("minecraft:zombie"));
                this.put("additionalZombieDrops", List.of("minecraft:rotten_flesh=0.9", "minecraft:bone=0.1", "minecraft:carrot=0.009", "minecraft:potato=0.0009", "minecraft:iron_nugget=0.0005", "minecraft:gold_nugget=0.0001"));
                this.put("heavilyArmoredZombiesEnabled", false);
                this.put("dayCounterEnabled", true);
                this.put("zombiesBreakBlocks", true);
                this.put("zombieBlockBreakReach", 3);
                this.put("blockMinimumHardness", 0);
                this.put("blockMaximumHardness", 3);
            }
        };
        comments = new LinkedHashMap<String, String>(){
            {
                this.put("entityMultiplierRate", "PLEASE READ THE INSTRUCTIONS ON THE MOD PAGE TO PREVENT MISTAKES!\n---");
                this.put("entityMultiplierEntities", "Entities multiplied by entityMultiplierRate upon spawning");
                this.put("entityBlocklistEntities", "Entities which will be restricted from spawning");
                this.put("daylightResistantEntities", "These entities won't burn in the day (from daylight)");
                this.put("additionalZombieDrops", "List of additional drops and drop chances for zombies");
                this.put("heavilyArmoredZombiesEnabled", "Enable heavily armored zombies");
                this.put("dayCounterEnabled", "Enable day counter");
                this.put("zombiesBreakBlocks", "Whether zombies can break blocks or not");
                this.put("zombieBlockBreakReach", "Block breaking reach of zombies");
                this.put("blockMinimumHardness", "Minimum hardness of blocks that should be broken");
                this.put("blockMaximumHardness", "Maximum hardness of blocks that should be broken");
            }
        };
    }
}

