/*
 * Decompiled with CFR 0.152.
 */
package com.zac;

import com.zac.Config;
import com.zac.features.CustomZombieDrops;
import com.zac.features.DayCounter;
import com.zac.features.EntityHandler;
import com.zac.features.HeavilyArmorZombies;
import com.zac.features.NoDaylightBurning;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZombieApocalypseCore
implements ModInitializer {
    public static final String MOD_ID = "zac";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"zac");
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STOPPING.register(Config::onServerStopping);
        Config.init(FabricLoader.getInstance().getConfigDir().resolve("zac-common.toml").toString());
        EntityHandler.register();
        DayCounter.register();
        HeavilyArmorZombies.register();
        NoDaylightBurning.register();
        CustomZombieDrops.register();
        ServerTickEvents.END_SERVER_TICK.register(ZombieApocalypseCore::tick);
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    public static void tick(MinecraftServer server) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setValue((Integer)work.getValue() - 1);
            if ((Integer)work.getValue() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getKey()).run());
        workQueue.removeAll(actions);
    }
}

