/*
 * Decompiled with CFR 0.152.
 */
package com.zac.features;

import com.zac.Config;
import com.zac.WorldData;
import com.zac.ZombieApocalypseCore;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class DayCounter {
    private static String[] messages = new String[]{"-", "--", "- -", "- D -", "- DA -", "- DAY -", "- DAY X -"};
    private static final HashMap<UUID, Integer> time = new HashMap();

    public static void playSoundAndSendMsg(Player player, String msg) {
        SoundEvent sound = SoundEvents.STONE_BUTTON_CLICK_ON;
        BlockPos blockpos = BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ());
        player.level().playSound(null, blockpos, sound, SoundSource.NEUTRAL, 3.0f, 3.0f);
        player.displayClientMessage((Component)Component.literal((String)msg), true);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player;
        Level world;
        Player player2;
        if (Config.dayCounterEnabled && (player2 = event.getEntity()) instanceof Player && !(world = (player = player2).level()).isClientSide() && world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            if (world.dayTime() % 24000L == 1L) {
                WorldData data = WorldData.get(level);
                int day = data.getDay() + 1;
                data.setDay(day);
                UUID playerUUID = player.getUUID();
                time.put(playerUUID, 0);
                int savedTime = time.get(playerUUID);
                for (String message : messages) {
                    time.put(playerUUID, savedTime += 10);
                    ZombieApocalypseCore.queueServerWork(savedTime, () -> DayCounter.playSoundAndSendMsg(player, message.replace("X", String.valueOf(day))));
                }
                time.put(player.getUUID(), 0);
            }
        }
    }
}

