/*
 * Decompiled with CFR 0.152.
 */
package com.zac.features;

import com.zac.Config;
import com.zac.features.HeavilyArmorZombies;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber
public class EntityHandler {
    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        String entityRegistryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
        if (Config.entityBlocklistEntities.contains(entityRegistryName)) {
            if (entity instanceof Mob && !entity.level().isClientSide) {
                event.setCanceled(true);
            }
        } else if (Config.entityMultiplierEntities.contains(entityRegistryName) && entity instanceof Mob && !entity.getTags().contains("multiplied")) {
            Level level;
            entity.addTag("multiplied");
            int multiplier = Config.entityMultiplierRate;
            if (multiplier > 1 && (level = entity.level()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                for (int i = 0; i < multiplier - 1; ++i) {
                    Entity newEntity;
                    EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)entityRegistryName));
                    if (entityType == null || (newEntity = entityType.create((Level)level2)) == null) continue;
                    double offsetX = entity.getX() + (Math.random() - 0.5);
                    double offsetY = entity.getY();
                    double offsetZ = entity.getZ() + (Math.random() - 0.5);
                    newEntity.moveTo(offsetX, offsetY, offsetZ, entity.getYRot(), entity.getXRot());
                    newEntity.addTag("multiplied");
                    level2.addFreshEntity(newEntity);
                    HeavilyArmorZombies.whatAreTheChances(newEntity);
                }
            }
        }
    }
}

