/*
 * Decompiled with CFR 0.152.
 */
package com.tmquan2508.ServerInfoCommand;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.tmquan2508.ServerInfoCommand.commands.Command;
import com.tmquan2508.ServerInfoCommand.event.ServerInfoEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2596;
import net.minecraft.class_2639;
import net.minecraft.class_2805;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfoCommandMod
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ServerInfoCommand");
    public static final String MODID = "serverinfocommand";
    private static final float[] tickRates = new float[20];
    private static int nextTickRateIndex = 0;
    private static long lastTickTimeUpdateMillis = -1L;
    private static long timeGameJoinedMillis = -1L;
    private static final Set<String> commandTreePlugins = Collections.synchronizedSet(new HashSet());
    private static final Set<String> completionPlugins = Collections.synchronizedSet(new HashSet());
    private static String versionCommandAlias = null;
    private static final Set<String> VERSION_ALIASES = Set.of("version", "ver", "about", "bukkit:version", "bukkit:ver", "bukkit:about", "icanhasbukkit");
    private static final Set<String> ANTICHEAT_LIST = Set.of("nocheatplus", "negativity", "warden", "horizon", "illegalstack", "coreprotect", "exploitsx", "vulcan", "abc", "spartan", "kauri", "anticheatreloaded", "witherac", "godseye", "matrix", "wraith", "antixrayheuristics", "grimac");
    private static final Random RANDOM = new Random();
    private static int pendingPluginTransactionId = -1;
    private static boolean waitingForPluginSuggestions = false;
    private static int pluginRequestTimeoutTicks = 0;
    private static final int PLUGIN_REQUEST_TIMEOUT = 100;
    private static CompletableFuture<class_2639> pluginSuggestionsFuture = null;

    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> Command.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        this.registerConnectionEvents();
        this.registerCustomEventListeners();
        this.registerTickListeners();
        LOGGER.info("ServerInfoCommand Initialized (with Mixin features).");
    }

    private void registerConnectionEvents() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ServerInfoCommandMod.resetTps();
            ServerInfoCommandMod.resetPlugins();
            timeGameJoinedMillis = -1L;
            LOGGER.info("Disconnected from server. State reset.");
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            ServerInfoCommandMod.resetTps();
            ServerInfoCommandMod.resetPlugins();
            lastTickTimeUpdateMillis = timeGameJoinedMillis = System.currentTimeMillis();
            LOGGER.info("Joined server. State reset.");
        });
    }

    private void registerCustomEventListeners() {
        ServerInfoEvents.WORLD_TIME_UPDATE_RECEIVED.register(this::handleWorldTimeUpdate);
        ServerInfoEvents.COMMAND_TREE_PROCESSED.register(this::handleCommandTree);
        ServerInfoEvents.COMMAND_SUGGESTIONS_RECEIVED.register(this::handleCommandSuggestions);
    }

    private void registerTickListeners() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (waitingForPluginSuggestions && --pluginRequestTimeoutTicks <= 0) {
                waitingForPluginSuggestions = false;
                int timedOutId = pendingPluginTransactionId;
                pendingPluginTransactionId = -1;
                LOGGER.warn("Plugin suggestion request timed out (ID: {}).", (Object)timedOutId);
                if (pluginSuggestionsFuture != null && !pluginSuggestionsFuture.isDone()) {
                    pluginSuggestionsFuture.complete(null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWorldTimeUpdate(long timeReceivedMillis) {
        if (timeGameJoinedMillis != -1L && lastTickTimeUpdateMillis != -1L) {
            float timeElapsedSeconds = (float)(timeReceivedMillis - lastTickTimeUpdateMillis) / 1000.0f;
            if (timeElapsedSeconds > 0.0f) {
                float currentRate = class_3532.method_15363((float)(20.0f / timeElapsedSeconds), (float)0.0f, (float)20.0f);
                float[] fArray = tickRates;
                synchronized (tickRates) {
                    ServerInfoCommandMod.tickRates[ServerInfoCommandMod.nextTickRateIndex] = currentRate;
                    nextTickRateIndex = (nextTickRateIndex + 1) % tickRates.length;
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                }
            } else {
                LOGGER.trace("Time elapsed since last time update is zero. Skipping rate calculation.");
            }
        }
        {
            lastTickTimeUpdateMillis = timeReceivedMillis;
            return;
        }
    }

    private void handleCommandTree(CommandDispatcher<class_2172> dispatcher) {
        if (dispatcher == null) {
            LOGGER.warn("Received null command dispatcher in handleCommandTree event.");
            return;
        }
        commandTreePlugins.clear();
        versionCommandAlias = null;
        RootCommandNode rootNode = dispatcher.getRoot();
        if (rootNode != null) {
            for (CommandNode node : rootNode.getChildren()) {
                String name = node.getName();
                String[] parts = name.split(":", 2);
                if (parts.length > 1 && !parts[0].equalsIgnoreCase("minecraft") && !parts[0].equalsIgnoreCase("fabric")) {
                    commandTreePlugins.add(parts[0].toLowerCase());
                }
                if (versionCommandAlias != null || !VERSION_ALIASES.contains(name.toLowerCase())) continue;
                versionCommandAlias = name;
            }
            LOGGER.info("Processed command tree: Found {} potential plugins. Version alias: '{}'", (Object)commandTreePlugins.size(), (Object)versionCommandAlias);
        } else {
            LOGGER.warn("Command dispatcher root node was null during handleCommandTree event.");
        }
    }

    private void handleCommandSuggestions(class_2639 packet) {
        if (waitingForPluginSuggestions && pluginSuggestionsFuture != null && !pluginSuggestionsFuture.isDone()) {
            LOGGER.info("Received command suggestions, attempting to complete pending request (ID: {}).", (Object)pendingPluginTransactionId);
            pluginSuggestionsFuture.complete(packet);
        } else {
            LOGGER.trace("Received command suggestions but not waiting or future already completed/null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetTps() {
        float[] fArray = tickRates;
        synchronized (tickRates) {
            Arrays.fill(tickRates, 0.0f);
            // ** MonitorExit[var0] (shouldn't be in output)
            nextTickRateIndex = 0;
            lastTickTimeUpdateMillis = -1L;
            LOGGER.info("TPS tracker reset.");
            return;
        }
    }

    private static void resetPlugins() {
        commandTreePlugins.clear();
        completionPlugins.clear();
        versionCommandAlias = null;
        waitingForPluginSuggestions = false;
        pendingPluginTransactionId = -1;
        pluginRequestTimeoutTicks = 0;
        if (pluginSuggestionsFuture != null && !pluginSuggestionsFuture.isDone()) {
            pluginSuggestionsFuture.cancel(false);
            pluginSuggestionsFuture = null;
        }
        LOGGER.info("Plugin lists and request state reset.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getTps() {
        if (timeGameJoinedMillis == -1L || System.currentTimeMillis() - timeGameJoinedMillis < 4000L) {
            return 20.0;
        }
        int numTicks = 0;
        float sumTickRates = 0.0f;
        float[] fArray = tickRates;
        synchronized (tickRates) {
            for (float tickRate : tickRates) {
                if (!(tickRate > 0.0f)) continue;
                sumTickRates += tickRate;
                ++numTicks;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (numTicks == 0) {
                return 20.0;
            }
            return (double)sumTickRates / (double)numTicks;
        }
    }

    public static Set<String> getCommandTreePlugins() {
        return Collections.unmodifiableSet(commandTreePlugins);
    }

    public static Set<String> getCompletionPlugins() {
        return Collections.unmodifiableSet(completionPlugins);
    }

    public static CompletableFuture<List<String>> requestPluginsFromServer(class_634 networkHandler) {
        if (networkHandler == null) {
            LOGGER.error("requestPluginsFromServer called with null networkHandler.");
            return CompletableFuture.failedFuture(new IllegalStateException("Network handler is null."));
        }
        if (waitingForPluginSuggestions) {
            LOGGER.warn("Plugin request already in progress (ID: {}). Returning failed future.", (Object)pendingPluginTransactionId);
            return CompletableFuture.failedFuture(new IllegalStateException("Plugin request already in progress."));
        }
        if (versionCommandAlias == null) {
            LOGGER.info("No version command alias found, cannot request completion plugins.");
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        pendingPluginTransactionId = RANDOM.nextInt(0x7FFFFFFE) + 1;
        waitingForPluginSuggestions = true;
        pluginRequestTimeoutTicks = 100;
        completionPlugins.clear();
        pluginSuggestionsFuture = new CompletableFuture();
        class_2805 packet = new class_2805(pendingPluginTransactionId, versionCommandAlias + " ");
        networkHandler.method_52787((class_2596)packet);
        LOGGER.info("Sent plugin completion request with ID {} for command '{}'", (Object)pendingPluginTransactionId, (Object)versionCommandAlias);
        return ((CompletableFuture)pluginSuggestionsFuture.thenApply(suggestionsPacket -> {
            waitingForPluginSuggestions = false;
            pendingPluginTransactionId = -1;
            pluginRequestTimeoutTicks = 0;
            if (suggestionsPacket == null) {
                LOGGER.warn("Plugin suggestion request timed out.");
                return Collections.emptyList();
            }
            ArrayList foundPlugins = new ArrayList();
            suggestionsPacket.method_11397().getList().forEach(suggestion -> {
                String pluginName = suggestion.getText().toLowerCase();
                if (!commandTreePlugins.contains(pluginName) && completionPlugins.add(pluginName)) {
                    foundPlugins.add(pluginName);
                }
            });
            LOGGER.info("Received and processed {} new plugin suggestions.", (Object)foundPlugins.size());
            return new ArrayList<String>(completionPlugins);
        })).exceptionally(e -> {
            LOGGER.error("Error processing plugin suggestions future", e);
            waitingForPluginSuggestions = false;
            pendingPluginTransactionId = -1;
            pluginRequestTimeoutTicks = 0;
            return Collections.emptyList();
        });
    }

    public static String formatPluginName(String name) {
        String lowerName = name.toLowerCase();
        if (ANTICHEAT_LIST.contains(lowerName) || StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"exploit") || StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"cheat") || StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"illegal")) {
            return String.valueOf(class_124.field_1061) + name + String.valueOf(class_124.field_1080);
        }
        return String.valueOf(class_124.field_1075) + name + String.valueOf(class_124.field_1080);
    }
}

