/*
 * Decompiled with CFR 0.152.
 */
package com.tmquan2508.ServerInfoCommand.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.tmquan2508.ServerInfoCommand.ServerInfoCommandMod;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_639;
import net.minecraft.class_642;

public class Command {
    private static final Set<String> ANTICHEAT_LIST = Set.of("nocheatplus", "negativity", "warden", "horizon", "illegalstack", "coreprotect", "exploitsx", "vulcan", "abc", "spartan", "kauri", "anticheatreloaded", "witherac", "godseye", "matrix", "wraith", "antixrayheuristics", "grimac");
    private static final Set<String> VERSION_ALIASES = Set.of("version", "ver", "about", "bukkit:version", "bukkit:ver", "bukkit:about");

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder serverCommand = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"server").executes(ctx -> Command.runServerInfo((FabricClientCommandSource)ctx.getSource()));
        serverCommand.then(ClientCommandManager.literal((String)"info").executes(ctx -> Command.runServerInfo((FabricClientCommandSource)ctx.getSource())));
        serverCommand.then(ClientCommandManager.literal((String)"tps").executes(ctx -> Command.runTpsInfo((FabricClientCommandSource)ctx.getSource())));
        serverCommand.then(ClientCommandManager.literal((String)"plugins").executes(ctx -> Command.runPluginInfo((FabricClientCommandSource)ctx.getSource())));
        dispatcher.register(serverCommand);
    }

    private static int runServerInfo(FabricClientCommandSource source) {
        class_310 mc = source.getClient();
        class_634 networkHandler = mc.method_1562();
        if (mc.method_1496()) {
            Command.printSinglePlayerInfo(source, mc);
        } else if (networkHandler != null) {
            Command.printMultiPlayerInfo(source, mc, networkHandler);
        } else {
            Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Not connected to a server.").method_27692(class_124.field_1061));
            return 0;
        }
        return 1;
    }

    private static int runTpsInfo(FabricClientCommandSource source) {
        double tps = ServerInfoCommandMod.getTps();
        class_124 color = tps >= 19.5 ? class_124.field_1060 : (tps > 16.0 ? class_124.field_1054 : (tps > 12.0 ? class_124.field_1065 : class_124.field_1061));
        Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Server TPS: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f", tps)).method_27692(color)).method_10852((class_2561)class_2561.method_43470((String)" (Client-side estimate)").method_27692(class_124.field_1063)));
        return 1;
    }

    private static int runPluginInfo(FabricClientCommandSource source) {
        class_634 networkHandler = source.getClient().method_1562();
        if (networkHandler == null) {
            Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Not connected to a server.").method_27692(class_124.field_1061));
            return 0;
        }
        Consumer<class_2561> feedbackSender = msg -> Command.sendFeedback(source, msg);
        CompletableFuture<List<String>> futureCompletions = ServerInfoCommandMod.requestPluginsFromServer(networkHandler);
        futureCompletions.whenComplete((result, throwable) -> source.getClient().execute(() -> {
            if (throwable != null) {
                Command.handlePluginRequestError(throwable, feedbackSender);
            }
            Command.printDetectedPluginInfo(feedbackSender);
        }));
        if (!futureCompletions.isDone() && !futureCompletions.isCompletedExceptionally()) {
            Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Requesting plugin info from server...").method_27692(class_124.field_1054));
        }
        return 1;
    }

    private static void printSinglePlayerInfo(FabricClientCommandSource source, class_310 mc) {
        class_1132 integratedServer = mc.method_1576();
        Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Server Type: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"Singleplayer").method_27692(class_124.field_1075)));
        if (integratedServer != null) {
            Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Version: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)integratedServer.method_3827()).method_27692(class_124.field_1054)));
        }
        Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Difficulty: ").method_27692(class_124.field_1080).method_10852((class_2561)Command.formatDifficulty(source)));
        Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Day: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(Command.getDay(source))).method_27692(class_124.field_1054)));
        Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Permission Level: ").method_27692(class_124.field_1080).method_10852((class_2561)Command.formatPermissions(source)));
    }

    private static void printMultiPlayerInfo(FabricClientCommandSource source, class_310 mc, class_634 networkHandler) {
        class_642 serverInfo = mc.method_1558();
        if (serverInfo == null) {
            class_639 serverAddress = class_639.method_2950((String)networkHandler.method_48296().method_10755().toString());
            String displayAddress = serverAddress.method_2952() + ":" + serverAddress.method_2954();
            String resolvedIp = Command.resolveAddress(serverAddress.method_2952());
            class_5250 ipText = Command.createClickableIpText(displayAddress, resolvedIp, serverAddress.method_2954());
            Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"IP: ").method_27692(class_124.field_1080).method_10852((class_2561)ipText));
        } else {
            String displayAddress = serverInfo.field_3761;
            class_639 parsed = class_639.method_2950((String)displayAddress);
            String resolvedIp = Command.resolveAddress(parsed.method_2952());
            class_5250 ipText = Command.createClickableIpText(displayAddress, resolvedIp, parsed.method_2954());
            Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"IP: ").method_27692(class_124.field_1080).method_10852((class_2561)ipText));
            class_2561 motdText = (class_2561)Objects.requireNonNullElse(serverInfo.field_3757, class_2561.method_43470((String)"N/A").method_27692(class_124.field_1054));
            Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"MOTD: ").method_27692(class_124.field_1080).method_10852(motdText));
            Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Version: ").method_27692(class_124.field_1080).method_10852((class_2561)serverInfo.field_3760.method_27661().method_27692(class_124.field_1054)));
            Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Protocol: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(serverInfo.field_3756)).method_27692(class_124.field_1054)));
        }
        String brand = networkHandler.method_52790();
        Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Type: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)Objects.requireNonNullElse(brand, "unknown")).method_27692(brand == null ? class_124.field_1054 : class_124.field_1075)));
        Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Difficulty: ").method_27692(class_124.field_1080).method_10852((class_2561)Command.formatDifficulty(source)));
        Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Day: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(Command.getDay(source))).method_27692(class_124.field_1054)));
        Command.sendFeedback(source, (class_2561)class_2561.method_43470((String)"Permission Level: ").method_27692(class_124.field_1080).method_10852((class_2561)Command.formatPermissions(source)));
    }

    public static void printDetectedPluginInfo(Consumer<class_2561> feedbackSender) {
        Set<String> treePlugins = ServerInfoCommandMod.getCommandTreePlugins();
        Set<String> completionPlugins = ServerInfoCommandMod.getCompletionPlugins();
        TreeSet<String> combinedPlugins = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        combinedPlugins.addAll(treePlugins);
        combinedPlugins.addAll(completionPlugins);
        if (combinedPlugins.isEmpty()) {
            feedbackSender.accept((class_2561)class_2561.method_43470((String)"No plugins detected via commands/tab-completion.").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)" (Server might not expose them, or request timed out)").method_27692(class_124.field_1063)));
        } else {
            ArrayList sortedPlugins = new ArrayList(combinedPlugins);
            class_5250 pluginsText = class_2561.method_43473();
            for (int i = 0; i < sortedPlugins.size(); ++i) {
                String pluginName = (String)sortedPlugins.get(i);
                pluginsText.method_10852((class_2561)Command.formatPluginName(pluginName));
                if (i >= sortedPlugins.size() - 1) continue;
                pluginsText.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080));
            }
            feedbackSender.accept((class_2561)class_2561.method_43470((String)String.format("Detected Plugins (%d): ", sortedPlugins.size())).method_27692(class_124.field_1080).method_10852((class_2561)pluginsText));
        }
    }

    private static void handlePluginRequestError(Throwable throwable, Consumer<class_2561> feedbackSender) {
        Object errorMessage;
        class_124 format = class_124.field_1061;
        if (throwable instanceof IllegalStateException) {
            if (throwable.getMessage() != null && throwable.getMessage().contains("already in progress")) {
                return;
            }
            errorMessage = throwable.getMessage() != null && throwable.getMessage().contains("Network handler is null") ? "Error: Not connected to a server?" : "Error requesting plugins: " + (throwable.getMessage() != null ? throwable.getMessage() : "Unknown State Error");
        } else if (throwable instanceof TimeoutException) {
            errorMessage = "Plugin request timed out.";
            format = class_124.field_1054;
        } else {
            errorMessage = "Error processing plugin request: " + (throwable.getMessage() != null ? throwable.getMessage() : throwable.getClass().getSimpleName());
        }
        feedbackSender.accept((class_2561)class_2561.method_43470((String)errorMessage).method_27692(format));
        if (format == class_124.field_1061) {
            ServerInfoCommandMod.LOGGER.error("Plugin request future failed:", throwable);
        }
    }

    private static String resolveAddress(String address) {
        if ("localhost".equalsIgnoreCase(address) || "127.0.0.1".equals(address) || "0.0.0.0".equals(address)) {
            return address;
        }
        try {
            return InetAddress.getByName(address).getHostAddress();
        }
        catch (UnknownHostException e) {
            ServerInfoCommandMod.LOGGER.warn("Could not resolve hostname: {}", (Object)address);
            return address;
        }
        catch (SecurityException e) {
            ServerInfoCommandMod.LOGGER.warn("Security manager prevented resolving hostname: {}", (Object)address);
            return address;
        }
    }

    private static class_5250 createClickableIpText(String displayAddress, String resolvedIp, int port) {
        String addressOnly = displayAddress;
        if (displayAddress.contains(":")) {
            addressOnly = displayAddress.substring(0, displayAddress.lastIndexOf(58));
        }
        boolean showResolved = !resolvedIp.equals(addressOnly) && !resolvedIp.equals("127.0.0.1");
        String fullDisplayAddressWithPort = addressOnly + ":" + port;
        String fullResolvedIpWithPort = resolvedIp + ":" + port;
        class_5250 ipText = class_2561.method_43470((String)addressOnly).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(":" + port)).method_27692(class_124.field_1080)).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10606(fullDisplayAddressWithPort)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to copy").method_27692(class_124.field_1068))));
        if (showResolved) {
            ipText.method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)resolvedIp).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(":" + port)).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1080)).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10606(fullResolvedIpWithPort)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to copy").method_27692(class_124.field_1068)))));
        }
        return ipText;
    }

    private static class_5250 formatDifficulty(FabricClientCommandSource source) {
        class_1267 difficulty = source.getWorld().method_8407();
        class_5250 difficultyText = difficulty.method_5463().method_27661().method_27692(class_124.field_1054);
        try {
            if (source.getPlayer() != null) {
                double localDifficulty = source.getWorld().method_8404(source.getPlayer().method_24515()).method_5457();
                difficultyText.method_10852((class_2561)class_2561.method_43470((String)String.format(" (Local: %.2f)", localDifficulty)).method_27692(class_124.field_1062));
            }
        }
        catch (Exception e) {
            ServerInfoCommandMod.LOGGER.warn("Could not get local difficulty", (Throwable)e);
            difficultyText.method_10852((class_2561)class_2561.method_43470((String)" (Local: N/A)").method_27692(class_124.field_1062));
        }
        return difficultyText;
    }

    private static class_5250 formatPermissions(FabricClientCommandSource source) {
        int level = 0;
        for (int i = 4; i >= 0; --i) {
            if (!source.method_9259(i)) continue;
            level = i;
            break;
        }
        String desc = switch (level) {
            case 0 -> "0 (Player)";
            case 1 -> "1 (Moderator)";
            case 2 -> "2 (Game Master)";
            case 3 -> "3 (Admin)";
            case 4 -> "4 (Owner/OP)";
            default -> String.valueOf(level) + " (Unknown)";
        };
        return class_2561.method_43470((String)desc).method_27692(class_124.field_1054);
    }

    private static long getDay(FabricClientCommandSource source) {
        long time = source.getWorld().method_8532();
        return Math.max(0L, time / 24000L);
    }

    private static class_5250 formatPluginName(String pluginName) {
        String lowerPluginName = pluginName.toLowerCase(Locale.ROOT);
        if (ANTICHEAT_LIST.contains(lowerPluginName)) {
            return class_2561.method_43470((String)pluginName).method_27692(class_124.field_1061).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Anti-Cheat/Security Plugin").method_27692(class_124.field_1061))));
        }
        if (VERSION_ALIASES.contains(lowerPluginName)) {
            return class_2561.method_43470((String)pluginName).method_27692(class_124.field_1061).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Version Info Command").method_27692(class_124.field_1054))));
        }
        return class_2561.method_43470((String)pluginName).method_27692(class_124.field_1068);
    }

    private static void sendFeedback(FabricClientCommandSource source, class_2561 message) {
        class_5250 prefix = class_2561.method_43470((String)"[").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"Server").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"] ").method_27692(class_124.field_1080));
        class_5250 fullMessage = prefix.method_10852(message);
        source.sendFeedback((class_2561)fullMessage);
    }
}

