/*
 * Decompiled with CFR 0.152.
 */
package xyz.tangledwires.fracturedspawners;

import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.tangledwires.fracturedspawners.bukkit.Metrics;
import xyz.tangledwires.fracturedspawners.events.DropSpawners;
import xyz.tangledwires.fracturedspawners.events.NoPlaceFracturedSpawner;
import xyz.tangledwires.fracturedspawners.events.PlaceRepairedSpawner;
import xyz.tangledwires.fracturedspawners.events.RepairedSpawnerRecipe;

public class FracturedSpawners
extends JavaPlugin {
    public void onEnable() {
        int pluginId = 21486;
        Metrics metrics = new Metrics(this, pluginId);
        FileConfiguration config = this.getConfig();
        ArrayList<String> defaultAllowedTools = new ArrayList<String>();
        defaultAllowedTools.add("*");
        config.addDefault("silkTouchRequired", (Object)false);
        config.addDefault("spawnerDropsInCreative", (Object)false);
        config.addDefault("allowedTools", defaultAllowedTools);
        config.addDefault("repairedSpawnersStayRepaired", (Object)true);
        config.options().copyDefaults(true);
        this.saveConfig();
        this.setupRecipes();
        this.getServer().getPluginManager().registerEvents((Listener)new DropSpawners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RepairedSpawnerRecipe(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new NoPlaceFracturedSpawner(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlaceRepairedSpawner(), (Plugin)this);
        this.getLogger().info("FracturedSpawners enabled!");
    }

    public void onDisable() {
        this.getLogger().info("FracturedSpawners disabled!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("fracturedspawners") && args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            this.reloadConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Config reloaded!");
            return true;
        }
        return false;
    }

    public void setupRecipes() {
        NamespacedKey key = new NamespacedKey((Plugin)this, "repaired_spawner");
        ItemStack resultSpawner = new ItemStack(Material.SPAWNER);
        ItemMeta m = resultSpawner.getItemMeta();
        m.setDisplayName(String.valueOf(ChatColor.GOLD) + "Repaired Spawner");
        ShapedRecipe spawnerRecipe = new ShapedRecipe(key, resultSpawner);
        spawnerRecipe.shape(new String[]{"*#*", "#@#", "*#*"});
        spawnerRecipe.setIngredient('*', Material.DIAMOND);
        spawnerRecipe.setIngredient('#', Material.ECHO_SHARD);
        spawnerRecipe.setIngredient('@', Material.SPAWNER);
        this.getServer().addRecipe((Recipe)spawnerRecipe);
    }

    public List<Material> getAllowedTools() {
        FileConfiguration config = this.getConfig();
        List allowedToolsStrings = config.getStringList("allowedTools");
        ArrayList<Material> allowedToolsMaterials = new ArrayList<Material>();
        if (allowedToolsStrings.contains("*")) {
            for (Material m : Material.values()) {
                allowedToolsMaterials.add(m);
            }
        } else {
            for (String allowed : allowedToolsStrings) {
                allowedToolsMaterials.add(Material.matchMaterial((String)allowed));
            }
        }
        return allowedToolsMaterials;
    }
}

