/*
 * Decompiled with CFR 0.152.
 */
package xyz.tangledwires.fracturedspawners.util;

import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import xyz.tangledwires.fracturedspawners.FracturedSpawners;

public class PersistantDataContainerUtils {
    private static NamespacedKey fracturedNamespace = new NamespacedKey((Plugin)FracturedSpawners.getPlugin(FracturedSpawners.class), "isFracturedSpawner");
    private static NamespacedKey repairedNamespace = new NamespacedKey((Plugin)FracturedSpawners.getPlugin(FracturedSpawners.class), "isRepairedSpawner");

    private PersistantDataContainerUtils() {
    }

    public static boolean isFracturedSpawner(ItemStack i) {
        ItemMeta m = i.getItemMeta();
        if (m != null) {
            PersistentDataContainer pdc = m.getPersistentDataContainer();
            return PersistantDataContainerUtils.isFracturedSpawner(pdc);
        }
        return false;
    }

    public static boolean isFracturedSpawner(PersistentDataContainer pdc) {
        if (pdc.get(fracturedNamespace, PersistentDataType.BOOLEAN) != null) {
            return (Boolean)pdc.get(fracturedNamespace, PersistentDataType.BOOLEAN);
        }
        return false;
    }

    public static void setIsFracturedSpawner(ItemStack i, boolean b) {
        ItemMeta m = i.getItemMeta();
        if (m != null) {
            PersistentDataContainer pdc = m.getPersistentDataContainer();
            pdc.set(fracturedNamespace, PersistentDataType.BOOLEAN, (Object)b);
            i.setItemMeta(m);
        }
    }

    public static void setIsFracturedSpawner(PersistentDataContainer pdc, boolean b) {
        pdc.set(fracturedNamespace, PersistentDataType.BOOLEAN, (Object)b);
    }

    public static boolean isRepairedSpawner(ItemStack i) {
        ItemMeta m = i.getItemMeta();
        if (m != null) {
            PersistentDataContainer pdc = m.getPersistentDataContainer();
            return PersistantDataContainerUtils.isRepairedSpawner(pdc);
        }
        return false;
    }

    public static boolean isRepairedSpawner(PersistentDataContainer pdc) {
        if (pdc.get(repairedNamespace, PersistentDataType.BOOLEAN) != null) {
            return (Boolean)pdc.get(repairedNamespace, PersistentDataType.BOOLEAN);
        }
        return false;
    }

    public static void setIsRepairedSpawner(ItemStack i, boolean b) {
        ItemMeta m = i.getItemMeta();
        if (m != null) {
            PersistentDataContainer pdc = m.getPersistentDataContainer();
            pdc.set(repairedNamespace, PersistentDataType.BOOLEAN, (Object)b);
            i.setItemMeta(m);
        }
    }

    public static void setIsRepairedSpawner(PersistentDataContainer pdc, boolean b) {
        pdc.set(repairedNamespace, PersistentDataType.BOOLEAN, (Object)b);
    }
}

