/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.sit;

import bl4ckscor3.mod.sit.Configuration;
import bl4ckscor3.mod.sit.SitEntity;
import bl4ckscor3.mod.sit.SitUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="sit")
public class SitHandler {
    private SitHandler() {
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        BlockState state;
        BlockPos pos;
        Level level;
        Player player = event.getEntity();
        if (!event.getLevel().isClientSide() && event.getFace() == Direction.UP && !SitUtil.isPlayerSitting(player) && !player.isShiftKeyDown() && SitHandler.isValidBlock(level = event.getLevel(), pos = event.getPos(), state = level.getBlockState(pos), block = level.getBlockState(pos).getBlock()) && SitHandler.isPlayerInRange(player, pos) && !SitUtil.isOccupied(level, pos) && player.getMainHandItem().isEmpty() && level.getBlockState(pos.above()).isAir()) {
            if (block instanceof SlabBlock && (!state.hasProperty((Property)SlabBlock.TYPE) || state.getValue((Property)SlabBlock.TYPE) != SlabType.BOTTOM)) {
                return;
            }
            if (block instanceof StairBlock && (!state.hasProperty((Property)StairBlock.HALF) || state.getValue((Property)StairBlock.HALF) != Half.BOTTOM)) {
                return;
            }
            SitEntity sit = new SitEntity(level, pos);
            if (SitUtil.addSitEntity(level, pos, sit, player.position())) {
                level.addFreshEntity((Entity)sit);
                player.startRiding((Entity)sit);
            }
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        SitEntity entity;
        if (!event.getLevel().isClientSide() && (entity = SitUtil.getSitEntity((Level)event.getLevel(), event.getPos())) != null) {
            SitUtil.removeSitEntity((Level)event.getLevel(), event.getPos());
            entity.ejectPassengers();
        }
    }

    private static boolean isValidBlock(Level level, BlockPos pos, BlockState state, Block block) {
        boolean isValid;
        boolean bl = isValid = block instanceof SlabBlock || block instanceof StairBlock || SitHandler.isModBlock(block);
        if (!isValid && block instanceof BedBlock && !((state = level.getBlockState(pos.relative(state.getValue((Property)BedBlock.PART) == BedPart.HEAD ? ((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite() : (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)))).getBlock() instanceof BedBlock)) {
            isValid = true;
        }
        return isValid;
    }

    private static boolean isModBlock(Block block) {
        return false;
    }

    private static boolean isPlayerInRange(Player player, BlockPos pos) {
        BlockPos playerPos = player.blockPosition();
        int blockReachDistance = (Integer)Configuration.CONFIG.blockReachDistance.get();
        if (blockReachDistance == 0) {
            return playerPos.getY() - pos.getY() <= 1 && playerPos.getX() - pos.getX() == 0 && playerPos.getZ() - pos.getZ() == 0;
        }
        pos = BlockPos.containing((double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5));
        AABB range = new AABB((double)(pos.getX() + blockReachDistance), (double)(pos.getY() + blockReachDistance), (double)(pos.getZ() + blockReachDistance), (double)(pos.getX() - blockReachDistance), (double)(pos.getY() - blockReachDistance), (double)(pos.getZ() - blockReachDistance));
        return range.minX <= (double)(playerPos = BlockPos.containing((double)((double)playerPos.getX() + 0.5), (double)((double)playerPos.getY() + 0.5), (double)((double)playerPos.getZ() + 0.5))).getX() && range.minY <= (double)playerPos.getY() && range.minZ <= (double)playerPos.getZ() && range.maxX >= (double)playerPos.getX() && range.maxY >= (double)playerPos.getY() && range.maxZ >= (double)playerPos.getZ();
    }
}

