/*
 * Decompiled with CFR 0.152.
 */
package net.dianacraft.lifeskins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.dianacraft.lifeskins.util.SkinPathFinder;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeLivesManager;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.samo_lego.fabrictailor.command.SkinCommand;
import org.samo_lego.fabrictailor.util.SkinFetcher;

public class LifeSkinsCommand {
    private static int contextReloadSkin(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        int result = LifeSkinsCommand.reloadSkin(player);
        SkinPathFinder spf = new SkinPathFinder(player);
        if (!Main.livesManager.hasAssignedLives(player)) {
            player.method_64398(class_2561.method_30163((String)"You have not been assigned any lives yet."));
            return -1;
        }
        if (!spf.hasSkins()) {
            player.method_7353(class_2561.method_30163((String)"\u00a7cCouldn't find any life skins! Make sure you set them up correctly, run \"/lifeskins setup\" to get setup instructions"), false);
            return -1;
        }
        return result;
    }

    public static int reloadSkin(class_3222 player) throws CommandSyntaxException {
        SkinPathFinder spf = new SkinPathFinder(player);
        if (Main.livesManager.hasAssignedLives(player) && spf.hasSkins() && player.method_5805()) {
            if (Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE) {
                SkinCommand.setSkin((class_3222)player, () -> SkinFetcher.setSkinFromFile((String)spf.getSkinPath(LifeSkinsCommand.getLivesForLimited(player)), (boolean)SkinPathFinder.getSlim(spf.getSkin(LifeSkinsCommand.getLivesForLimited(player)))));
            } else {
                SkinCommand.setSkin((class_3222)player, () -> SkinFetcher.setSkinFromFile((String)spf.getSkinPath(), (boolean)SkinPathFinder.getSlim(spf.getSkin(Main.livesManager.getPlayerLives(player)))));
            }
            return 1;
        }
        return -1;
    }

    public static void reloadSkin(class_3222 player, int lives) throws CommandSyntaxException {
        SkinPathFinder spf = new SkinPathFinder(player);
        if (spf.hasSkins() && player.method_5805()) {
            SkinCommand.setSkin((class_3222)player, () -> SkinFetcher.setSkinFromFile((String)spf.getSkinPath(lives), (boolean)SkinPathFinder.getSlim(spf.getSkin(lives))));
        }
    }

    public static int getLivesForLimited(class_3222 player) {
        if (Main.livesManager.hasAssignedLives(player)) {
            Integer lives = Main.livesManager.getPlayerLives(player);
            if (lives == null) {
                return 0;
            }
            return LifeSkinsCommand.getLivesForLimited(lives);
        }
        return 0;
    }

    public static int getLivesForLimited(Integer time) {
        if (time <= 0) {
            return 0;
        }
        if (time > LimitedLifeLivesManager.YELLOW_TIME) {
            return 3;
        }
        if (time > LimitedLifeLivesManager.RED_TIME) {
            return 2;
        }
        return 1;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lifeskins").then(class_2170.method_9247((String)"reload").executes(LifeSkinsCommand::contextReloadSkin))).then(class_2170.method_9247((String)"setup").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player != null) {
                player.method_64398(class_2561.method_30163((String)"\u00a7e| Skin setup info:"));
                player.method_64398(class_2561.method_30163((String)"In the config folder create a folder with your username and put the skins you want to use inside!"));
                player.method_64398(class_2561.method_30163((String)"Each skin must be named after the minimum amount of lives you need for it"));
                player.method_64398(class_2561.method_30163((String)"For example, \u00a7e\"4.png\" will activate when you have 4 or more lives"));
                player.method_64398(class_2561.method_30163((String)"If you want a slim-type skin, you need to create a skins.json file in the same folder and put the following text inside:"));
                player.method_64398(class_2561.method_30163((String)"\u00a7b{ \"slim\": true }"));
            }
            return 1;
        }))).then(class_2170.method_9247((String)"skins").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player != null) {
                SkinPathFinder spf = new SkinPathFinder(player);
                return spf.logSkins();
            }
            return -1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reloadAll").requires(source -> PermissionManager.isAdmin((class_3222)source.method_44023()) || source.method_9228() == null)).executes(context -> {
            for (class_3222 player : PlayerUtils.getAllFunctioningPlayers()) {
                SkinPathFinder spf = new SkinPathFinder(player);
                if (!spf.hasSkins()) continue;
                try {
                    LifeSkinsCommand.reloadSkin(player);
                }
                catch (NullPointerException nullPointerException) {}
            }
            return -1;
        })));
    }
}

