/*
 * Decompiled with CFR 0.152.
 */
package net.dianacraft.lifeskins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.dianacraft.lifeskins.util.Skin;
import net.dianacraft.lifeskins.util.SkinPathFinder;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeLivesManager;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.samo_lego.fabrictailor.command.SkinCommand;
import org.samo_lego.fabrictailor.util.SkinFetcher;

public class LifeSkinsCommand {
    private static int contextReloadSkin(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        SkinPathFinder spf = new SkinPathFinder(player);
        if (!Main.livesManager.hasAssignedLives(player)) {
            player.method_64398(class_2561.method_30163((String)"You have not been assigned any lives yet."));
            return -1;
        }
        if (!spf.hasSkins()) {
            player.method_7353(class_2561.method_30163((String)"\u00a7cCouldn't find any life skins! Make sure you set them up correctly, run \"/lifeskins setup\" to get setup instructions"), false);
            return -1;
        }
        return LifeSkinsCommand.reloadSkin(player);
    }

    public static int reloadSkin(class_3222 player) {
        SkinPathFinder spf = new SkinPathFinder(player);
        Skin skin = Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE ? spf.getSkin(LifeSkinsCommand.getLivesForLimited(player)) : spf.getSkin();
        if (skin == null) {
            SkinCommand.setSkin((class_3222)player, () -> SkinFetcher.fetchSkinByName((String)player.method_5820()));
            return -1;
        }
        SkinCommand.setSkin((class_3222)player, () -> SkinFetcher.setSkinFromFile((String)spf.getSkinPath(skin), (boolean)skin.getSlim()));
        return 1;
    }

    public static void reloadSkin(class_3222 player, Skin skin) {
        if (skin != null) {
            SkinPathFinder spf = new SkinPathFinder(player);
            SkinCommand.setSkin((class_3222)player, () -> SkinFetcher.setSkinFromFile((String)spf.getSkinPath(skin), (boolean)skin.getSlim()));
        }
    }

    public static void stealSkin(class_3222 actor, String target) {
        SkinPathFinder spf = new SkinPathFinder(actor, target);
        Skin skin = spf.getSkin();
        if (skin == null) {
            SkinCommand.setSkin((class_3222)actor, () -> SkinFetcher.fetchSkinByName((String)target));
        } else {
            SkinCommand.setSkin((class_3222)actor, () -> SkinFetcher.setSkinFromFile((String)spf.getSkinPath(skin), (boolean)skin.getSlim()));
        }
    }

    public static void stealSkin(class_3222 actor, String target, Skin skin) {
        SkinPathFinder spf = new SkinPathFinder(actor, target);
        if (skin == null) {
            SkinCommand.setSkin((class_3222)actor, () -> SkinFetcher.fetchSkinByName((String)target));
        } else {
            SkinCommand.setSkin((class_3222)actor, () -> SkinFetcher.setSkinFromFile((String)spf.getSkinPath(skin), (boolean)skin.getSlim()));
        }
    }

    public static int getLivesForLimited(class_3222 player) {
        if (Main.livesManager.hasAssignedLives(player)) {
            Integer lives = Main.livesManager.getPlayerLives(player);
            if (lives == null) {
                return 0;
            }
            return LifeSkinsCommand.getLivesForLimited(lives);
        }
        return 0;
    }

    public static int getLivesForLimited(Integer time) {
        if (time <= 0) {
            return 0;
        }
        if (time <= LimitedLifeLivesManager.RED_TIME) {
            return 1;
        }
        if (time <= LimitedLifeLivesManager.YELLOW_TIME) {
            return 2;
        }
        return time <= LimitedLifeLivesManager.DEFAULT_TIME ? 3 : 4;
    }

    public static int reloadSkin(Collection<class_3222> players) {
        for (class_3222 player : players) {
            LifeSkinsCommand.reloadSkin(player);
        }
        return 0;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lifeskins").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").executes(LifeSkinsCommand::contextReloadSkin)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).requires(source -> PermissionManager.isAdmin((class_3222)source.method_44023()) || source.method_9228() == null)).executes(context -> LifeSkinsCommand.reloadSkin(class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"setup").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player != null) {
                player.method_64398(class_2561.method_30163((String)"\u00a7e| Skin setup info:"));
                player.method_64398(class_2561.method_30163((String)"In the config folder create a folder with your username and put the skins you want to use inside!"));
                player.method_64398(class_2561.method_30163((String)"Each skin must be named after the minimum amount of lives you need for it"));
                player.method_64398(class_2561.method_30163((String)"For example, \u00a7e\"4.png\" will activate when you have 4 or more lives"));
                player.method_64398(class_2561.method_30163((String)"If you want a slim-type skin, you need to create a skins.json file in the same folder and put the following text inside:"));
                player.method_64398(class_2561.method_30163((String)"\u00a7b{ \"slim\": true }"));
            }
            return 1;
        }))).then(class_2170.method_9247((String)"skins").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            if (player != null) {
                SkinPathFinder spf = new SkinPathFinder(player);
                return spf.logSkins();
            }
            return -1;
        })));
    }
}

