/*
 * Decompiled with CFR 0.152.
 */
package net.dianacraft.lifeskins.util;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.dianacraft.lifeskins.LifeSkins;
import net.dianacraft.lifeskins.command.LifeSkinsCommand;
import net.dianacraft.lifeskins.util.Skin;
import net.dianacraft.lifeskins.util.SkinFile;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.subin.SubInManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SkinPathFinder {
    SkinFile skinFile;
    List<Skin> skins;
    List<Skin> teamSkins = new ArrayList<Skin>();
    Map<Integer, Skin> livesMap = new HashMap<Integer, Skin>();
    Map<String, Skin> teamMap = new HashMap<String, Skin>();
    private int lowest = 50;
    private int highest = -50;
    class_3222 player;
    String playerUsername;
    String directoryPath;

    public SkinPathFinder(class_3222 playerEntity) {
        this.player = playerEntity;
        this.playerUsername = SubInManager.isSubbingIn((UUID)playerEntity.method_5667()) ? OtherUtils.profileName((GameProfile)SubInManager.getSubstitutedPlayer((UUID)playerEntity.method_5667())) : playerEntity.method_5820();
        this.defaults();
    }

    public SkinPathFinder(class_3222 playerEntity, String subIn) {
        this.player = playerEntity;
        this.playerUsername = subIn;
        this.defaults();
    }

    private void defaults() {
        block7: {
            this.directoryPath = "config/lifeskins/" + this.playerUsername;
            this.skinFile = new SkinFile(false);
            Gson gson = new Gson();
            try {
                FileReader reader = new FileReader(this.directoryPath + "/skins.json");
                this.skinFile = (SkinFile)gson.fromJson((Reader)reader, SkinFile.class);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                if (new File(this.directoryPath).mkdir()) {
                    LifeSkins.LOGGER.info("Created a life skins folder for {}", (Object)this.playerUsername);
                }
                try {
                    FileWriter writer = new FileWriter(this.directoryPath + "/skins.json");
                    gson.toJson((Object)this.skinFile, (Appendable)writer);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (Exception f) {
                    if (!LifeSkins.LOGGER.isWarnEnabled()) break block7;
                    LifeSkins.LOGGER.warn("Failed to initialize a skins.json file for " + this.playerUsername);
                }
            }
        }
        if (this.skinFile.getSkinArray() == null) {
            this.skins = new SkinFile(false).getSkinArray();
        } else {
            this.skins = new ArrayList<Skin>(this.skinFile.getSkinArray());
            this.teamSkins = new ArrayList<Skin>(this.skinFile.getSkinArray());
            this.skins.removeIf(skin -> skin.getLifeCount() == null);
            this.teamSkins = this.skinFile.getSkinArray();
            this.teamSkins.removeIf(skin -> skin.getTeam() == null);
        }
        this.livesMap = this.initializeSkinMap();
        this.teamMap = this.initialiseTeamMap();
    }

    public boolean hasSkins() {
        if (this.skins.isEmpty()) {
            this.livesMap = this.initializeSkinMap();
        }
        return !this.skins.isEmpty() || !this.teamSkins.isEmpty();
    }

    public Skin getSkin() {
        Skin skin;
        if (this.player.method_5781() != null && (skin = this.getSkin(this.player.method_5781().method_1197())) != null) {
            return skin;
        }
        Integer playerLives = Main.livesManager.getPlayerLives(this.player);
        if (playerLives == null) {
            return null;
        }
        if (Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE) {
            playerLives = LifeSkinsCommand.getLivesForLimited(playerLives);
        }
        return this.getSkin(playerLives);
    }

    public Skin getSkin(int lives) {
        return this.getMapSkin(lives);
    }

    public Skin getSkin(String team) {
        if (this.player != null && team != null && this.teamMap.containsKey(team)) {
            return this.teamMap.get(team);
        }
        return null;
    }

    public String getSkinPath(Skin skin) {
        return this.directoryPath + "/" + skin.getName();
    }

    public Skin getMapSkin(Integer lives) {
        if (this.livesMap.isEmpty()) {
            return null;
        }
        if (this.livesMap.containsKey(lives)) {
            return this.livesMap.get(lives);
        }
        if (lives < this.lowest) {
            return this.livesMap.get(this.lowest);
        }
        if (lives > this.highest) {
            return this.livesMap.get(this.highest);
        }
        return null;
    }

    private ArrayList<Skin> findSkins() {
        ArrayList<Skin> skinArray = new ArrayList<Skin>();
        String[] allFiles = new File(this.directoryPath).list();
        if (allFiles == null) {
            return skinArray;
        }
        for (String file : allFiles) {
            String[] tmp = file.split("\\.");
            if (tmp.length != 2 || !Objects.equals(tmp[1], "png") || !tmp[0].matches("-?(0|[1-9]\\d*)")) continue;
            Skin skin = new Skin(tmp[0] + ".png", Integer.parseInt(tmp[0]), this.skinFile.getSlim());
            skinArray.add(skin);
        }
        return skinArray;
    }

    private Map<Integer, Skin> initializeSkinMap() {
        HashMap<Integer, Skin> map = new HashMap<Integer, Skin>();
        if (this.skins.isEmpty()) {
            this.skins = this.findSkins();
        }
        for (Skin skin : this.skins) {
            if (skin.getLifeCount() > this.highest) {
                this.highest = skin.getLifeCount();
            }
            if (skin.getLifeCount() >= this.lowest) continue;
            this.lowest = skin.getLifeCount();
        }
        Skin currentskin = new Skin("", -51);
        for (int i = this.lowest; i <= this.highest; ++i) {
            boolean hasskin = false;
            for (Skin skin : this.skins) {
                if (skin.getLifeCount() != i) continue;
                hasskin = true;
                currentskin = skin;
                map.put(i, skin);
            }
            if (hasskin) continue;
            map.put(i, currentskin);
        }
        return map;
    }

    public Map<String, Skin> initialiseTeamMap() {
        HashMap<String, Skin> skinMap = new HashMap<String, Skin>();
        if (this.teamSkins.isEmpty()) {
            return skinMap;
        }
        for (Skin skin : this.teamSkins) {
            skinMap.put(skin.getTeam(), skin);
        }
        return skinMap;
    }

    public int logSkins() {
        if (this.player == null) {
            return -1;
        }
        if (SubInManager.isSubbingIn((UUID)this.player.method_5667())) {
            this.player.method_64398(class_2561.method_30163((String)("\u00a7e| " + this.playerUsername + "'s skins:")));
        } else {
            this.player.method_64398(class_2561.method_30163((String)"\u00a7e| Your skins:"));
        }
        if (this.hasSkins()) {
            if (!this.teamSkins.isEmpty()) {
                this.player.method_64398(class_2561.method_30163((String)"\n| Team Skins:"));
                for (Skin skin : this.teamSkins) {
                    this.player.method_64398(class_2561.method_30163((String)(skin.getTeam() + ": \u00a7b" + skin.getName())));
                }
                this.player.method_64398(class_2561.method_30163((String)"\n| Life Skins:"));
            }
            if (!this.livesMap.isEmpty()) {
                for (int i = this.lowest; i <= this.highest; ++i) {
                    Object message = "";
                    if (i < this.highest && this.livesMap.get(i).equals(this.livesMap.get(i + 1))) continue;
                    message = this.livesMap.get(i).getLifeCount() == i ? (String)message + i : (String)message + this.livesMap.get(i).getLifeCount() + "-" + i;
                    if (i == this.highest) {
                        message = (String)message + "+";
                    }
                    if (((String)message).equals("1")) {
                        this.player.method_64398(class_2561.method_30163((String)((String)message + " Life: \u00a7b" + this.livesMap.get(i).getName())));
                        continue;
                    }
                    this.player.method_64398(class_2561.method_30163((String)((String)message + " Lives: \u00a7b" + this.livesMap.get(i).getName())));
                }
            } else {
                this.player.method_64398(class_2561.method_30163((String)"- none found. It is recommended but not required to\n have at least 1 life skin as a fallback"));
            }
        } else {
            this.player.method_64398(class_2561.method_30163((String)"- no skins found, run \"/lifeskins info\" to get setup instructions."));
        }
        return 1;
    }

    public Skin getSkin(class_3222 player) {
        SkinPathFinder spf = new SkinPathFinder(player);
        if (spf.hasSkins()) {
            if (Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE) {
                return spf.getSkin(LifeSkinsCommand.getLivesForLimited(player));
            }
            return spf.getSkin();
        }
        return null;
    }

    public Skin getSkin(class_3222 player, int lives) {
        SkinPathFinder spf = new SkinPathFinder(player);
        if (spf.hasSkins()) {
            if (Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE) {
                return spf.getSkin(LifeSkinsCommand.getLivesForLimited(lives));
            }
            return spf.getSkin(lives);
        }
        return null;
    }
}

