/*
 * Decompiled with CFR 0.152.
 */
package net.dianacraft.lifeskins.mixin;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.dianacraft.lifeskins.command.LifeSkinsCommand;
import net.dianacraft.lifeskins.util.SkinPathFinder;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.samo_lego.fabrictailor.command.SkinCommand;
import org.samo_lego.fabrictailor.util.SkinFetcher;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivesManager.class})
public abstract class LivesManagerMixin {
    @Shadow
    @Nullable
    public abstract Integer getPlayerLives(class_3222 var1);

    @Inject(method={"resetPlayerLife"}, at={@At(value="HEAD")})
    private void resetPlayerLife(class_3222 player, CallbackInfo ci) {
        SkinPathFinder spf = new SkinPathFinder(player);
        if (spf.hasSkins() && player.method_5805()) {
            SkinCommand.setSkin((class_3222)player, () -> SkinFetcher.fetchSkinByName((String)player.method_5477().getString()));
        }
    }

    @Inject(method={"setPlayerLives"}, at={@At(value="HEAD")})
    public void setPlayerLives(class_3222 player, int lives, CallbackInfo ci) {
        if (player == null) {
            return;
        }
        if (WatcherManager.isWatcher((class_1657)player)) {
            return;
        }
        int prevLives = -1;
        if (this.getPlayerLives(player) != null) {
            prevLives = this.getPlayerLives(player);
        }
        if (lives != prevLives) {
            try {
                LifeSkinsCommand.reloadSkin(player, lives);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }
}

