/*
 * Decompiled with CFR 0.152.
 */
package net.dianacraft.lifeskins.util;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dianacraft.lifeskins.LifeSkins;
import net.dianacraft.lifeskins.util.Skin;
import net.dianacraft.lifeskins.util.SkinFile;
import net.mat0u5.lifeseries.Main;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SkinPathFinder {
    SkinFile skinFile;
    List<Skin> skins;
    Map<Integer, Skin> skinMap;
    private int lowest;
    private int highest;
    class_3222 player;
    String directoryPath;

    public SkinPathFinder(class_3222 playerEntity) {
        block5: {
            this.lowest = 50;
            this.highest = -50;
            this.player = playerEntity;
            this.directoryPath = "config/lifeskins/" + this.player.method_5477().getString();
            this.skinFile = new SkinFile(false);
            Gson gson = new Gson();
            try {
                FileReader reader = new FileReader(this.directoryPath + "/skins.json");
                this.skinFile = (SkinFile)gson.fromJson((Reader)reader, SkinFile.class);
                ((Reader)reader).close();
            }
            catch (IOException e) {
                if (new File(this.directoryPath).mkdir()) {
                    LifeSkins.LOGGER.info("Created a life skins folder for {}", (Object)this.player.method_5477().getString());
                }
                try {
                    FileWriter writer = new FileWriter(this.directoryPath + "/skins.json");
                    gson.toJson((Object)this.skinFile, (Appendable)writer);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (Exception f) {
                    if (!LifeSkins.LOGGER.isWarnEnabled()) break block5;
                    LifeSkins.LOGGER.warn("Failed to initialize a skins.json file for " + this.player.method_5477().getString());
                }
            }
        }
        this.skins = this.skinFile.getSkinArray() == null ? new SkinFile(false).getSkinArray() : this.skinFile.getSkinArray();
        this.skinMap = this.initializeSkinMap();
    }

    public boolean hasSkins() {
        if (this.skins.isEmpty()) {
            this.skinMap = this.initializeSkinMap();
            return !this.skins.isEmpty();
        }
        return true;
    }

    public String getSkinPath() {
        int playerLives = 0;
        if (Main.livesManager.hasAssignedLives(this.player)) {
            playerLives = Main.livesManager.getPlayerLives(this.player);
        }
        return this.directoryPath + "/" + this.getSkin(playerLives).getName();
    }

    public String getSkinPath(int lives) {
        return this.directoryPath + "/" + this.getSkin(lives).getName();
    }

    public Skin getSkin(Integer lives) {
        if (this.skinMap.containsKey(lives)) {
            return this.skinMap.get(lives);
        }
        if (lives < this.lowest) {
            return this.skinMap.get(this.lowest);
        }
        if (lives > this.highest) {
            return this.skinMap.get(this.highest);
        }
        return null;
    }

    public static boolean getSlim(Skin skin) {
        return skin.getSlim();
    }

    private ArrayList<Skin> findSkins() {
        ArrayList<Skin> skinArray = new ArrayList<Skin>();
        String[] allFiles = new File(this.directoryPath).list();
        if (allFiles == null) {
            return skinArray;
        }
        for (String file : allFiles) {
            String[] tmp = file.split("\\.");
            if (tmp.length != 2 || !Objects.equals(tmp[1], "png") || !tmp[0].matches("-?(0|[1-9]\\d*)")) continue;
            Skin skin = new Skin(tmp[0] + ".png", Integer.parseInt(tmp[0]), this.skinFile.getSlim());
            skinArray.add(skin);
        }
        return skinArray;
    }

    private Map<Integer, Skin> initializeSkinMap() {
        HashMap<Integer, Skin> map = new HashMap<Integer, Skin>();
        if (this.skins.isEmpty()) {
            this.skins = this.findSkins();
        }
        for (Skin skin : this.skins) {
            if (skin.getLifeCount() > this.highest) {
                this.highest = skin.getLifeCount();
            }
            if (skin.getLifeCount() >= this.lowest) continue;
            this.lowest = skin.getLifeCount();
        }
        Skin currentskin = new Skin("", -51);
        for (int i = this.lowest; i <= this.highest; ++i) {
            boolean hasskin = false;
            for (Skin skin : this.skins) {
                if (skin.getLifeCount() != i) continue;
                hasskin = true;
                currentskin = skin;
                map.put(i, skin);
            }
            if (hasskin) continue;
            map.put(i, currentskin);
        }
        return map;
    }

    public int logSkins() {
        this.player.method_64398(class_2561.method_30163((String)"\u00a7e| Your skins:"));
        if (this.hasSkins()) {
            for (int i = this.lowest; i <= this.highest; ++i) {
                Object message = "";
                if (i < this.highest && this.skinMap.get(i).equals(this.skinMap.get(i + 1))) continue;
                message = this.skinMap.get(i).getLifeCount() == i ? (String)message + i : (String)message + this.skinMap.get(i).getLifeCount() + "-" + i;
                if (i == this.highest) {
                    message = (String)message + "+";
                }
                if (((String)message).equals("1")) {
                    this.player.method_64398(class_2561.method_30163((String)((String)message + " Life: \u00a7b" + this.skinMap.get(i).getName())));
                    continue;
                }
                this.player.method_64398(class_2561.method_30163((String)((String)message + " Lives: \u00a7b" + this.skinMap.get(i).getName())));
            }
        } else {
            this.player.method_64398(class_2561.method_30163((String)"- no skins found, run \"/lifeskins info\" to get setup instructions."));
        }
        return 1;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }
}

