/*
 * Decompiled with CFR 0.152.
 */
package me.kalbskinder.mob_Health;

import me.kalbskinder.mob_Health.Mob_Health;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Mob_HealthListener
implements Listener {
    private final Mob_Health plugin;

    public Mob_HealthListener(Mob_Health plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof LivingEntity && !((entity = (LivingEntity)entity2) instanceof Player)) {
            this.updateHealthBar(entity);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        event.getWorld().getLivingEntities().stream().filter(e -> !(e instanceof Player)).forEach(this::updateHealthBar);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        final LivingEntity entity2 = (LivingEntity)entity;
        double finalHealth = entity2.getHealth() - event.getFinalDamage();
        if (finalHealth <= 0.0) {
            entity2.setCustomName(null);
            entity2.setCustomNameVisible(false);
            return;
        }
        new BukkitRunnable(){

            public void run() {
                Mob_HealthListener.this.updateHealthBar(entity2);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        entity.setCustomName(null);
        entity.setCustomNameVisible(false);
    }

    @EventHandler
    public void onPlayerNameTagEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        final LivingEntity entity2 = (LivingEntity)entity;
        ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
        if (item.getType() != Material.NAME_TAG || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasDisplayName()) {
            return;
        }
        String newName = ChatColor.stripColor((String)meta.getDisplayName());
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_mob_name");
        entity2.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)newName);
        new BukkitRunnable(){

            public void run() {
                Mob_HealthListener.this.updateHealthBar(entity2);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    public void updateHealthBar(LivingEntity entity) {
        Object mobName;
        double health = Math.max(0.0, entity.getHealth());
        double maxHealth = entity.getAttribute(Attribute.MAX_HEALTH).getValue();
        FileConfiguration config = this.plugin.getConfig();
        String formatKey = health / maxHealth <= 0.4 ? "healthbar-low" : "healthbar-full";
        String format = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString(formatKey));
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "custom_mob_name");
        if (entity.getPersistentDataContainer().get(key, PersistentDataType.STRING) == null) {
            mobName = entity.getType().name().replace("_", " ").toLowerCase();
            mobName = Character.toUpperCase(((String)mobName).charAt(0)) + ((String)mobName).substring(1);
        } else {
            mobName = (String)entity.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        }
        String formattedHealth = health % 1.0 == 0.0 ? String.valueOf((int)health) : String.format("%.1f", health);
        String formattedMaxHealth = maxHealth % 1.0 == 0.0 ? String.valueOf((int)maxHealth) : String.format("%.1f", maxHealth);
        String name = format.replace("%mob%", (CharSequence)mobName).replace("%health%", formattedHealth).replace("%max_health%", formattedMaxHealth);
        entity.setCustomName(name);
        entity.setCustomNameVisible(true);
    }
}

