/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.yixixun.more_potion_effects.api.EffectUtils;

@Mod.EventBusSubscriber
public class ForceEffectCommand {
    private static final SuggestionProvider<CommandSourceStack> EFFECT_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)ForgeRegistries.MOB_EFFECTS.getKeys(), (SuggestionsBuilder)builder);

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"feffect").requires(s -> s.m_6761_(2));
        LiteralArgumentBuilder addEffect = (LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"effect", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(EFFECT_SUGGESTIONS).executes(ctx -> ForceEffectCommand.addEffect((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), ForceEffectCommand.getEffect((CommandContext<CommandSourceStack>)ctx, "effect"), 600, 0, false, ((CommandSourceStack)ctx.getSource()).m_81373_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ForceEffectCommand.addEffect((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), ForceEffectCommand.getEffect((CommandContext<CommandSourceStack>)ctx, "effect"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds") * 20, 0, false, ((CommandSourceStack)ctx.getSource()).m_81373_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amplifier", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ForceEffectCommand.addEffect((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), ForceEffectCommand.getEffect((CommandContext<CommandSourceStack>)ctx, "effect"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds") * 20, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amplifier"), false, ((CommandSourceStack)ctx.getSource()).m_81373_()))).then(Commands.m_82129_((String)"hideParticles", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ForceEffectCommand.addEffect((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), ForceEffectCommand.getEffect((CommandContext<CommandSourceStack>)ctx, "effect"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds") * 20, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amplifier"), BoolArgumentType.getBool((CommandContext)ctx, (String)"hideParticles"), ((CommandSourceStack)ctx.getSource()).m_81373_())))))));
        LiteralArgumentBuilder removeEffect = (LiteralArgumentBuilder)Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> ForceEffectCommand.removeAllEffects((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets")))).then(Commands.m_82129_((String)"effect", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(EFFECT_SUGGESTIONS).executes(ctx -> ForceEffectCommand.removeEffect((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), ForceEffectCommand.getEffect((CommandContext<CommandSourceStack>)ctx, "effect")))));
        command.then((ArgumentBuilder)addEffect);
        command.then((ArgumentBuilder)removeEffect);
        dispatcher.register(command);
    }

    private static MobEffect getEffect(CommandContext<CommandSourceStack> ctx, String arg) {
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)arg);
        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(id);
        if (effect == null) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u6548\u679cID: " + id);
        }
        return effect;
    }

    private static int addEffect(CommandSourceStack source, Collection<? extends Entity> targets, MobEffect effect, int duration, int amplifier, boolean hideParticles, @Nullable Entity sourceEntity) {
        int count = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            MobEffectInstance instance = new MobEffectInstance(effect, duration, amplifier, false, !hideParticles, true);
            EffectUtils.forceAddEffect(living, instance, sourceEntity);
            ++count;
        }
        if (count == 0) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u6ca1\u6709\u6709\u6548\u7684\u751f\u7269\u5b9e\u4f53"));
            return 0;
        }
        String effectName = effect.m_19482_().getString();
        String string = targets.iterator().next().m_5446_().getString();
        if (count > 1) {
            int finalCount = count;
            source.m_288197_(() -> Component.m_237113_((String)"\u5f3a\u5236\u6dfb\u52a0 %s \u6548\u679c\u7ed9 %d \u4e2a\u5b9e\u4f53".formatted(effectName + amplifier, finalCount)), true);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)("\u5f3a\u5236\u6dfb\u52a0 %s \u6548\u679c\u7ed9".formatted(effectName + amplifier) + entityName)), true);
        }
        return count;
    }

    private static int removeEffect(CommandSourceStack source, Collection<? extends Entity> targets, MobEffect effect) {
        int count = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            EffectUtils.forceRemoveEffect(living, effect);
            ++count;
        }
        if (count == 0) {
            source.m_81352_((Component)Component.m_237113_((String)"\u6ca1\u6709\u6709\u6548\u7684\u751f\u7269\u5b9e\u4f53"));
            return 0;
        }
        String effectName = effect.m_19482_().getString();
        String string = targets.iterator().next().m_5446_().getString();
        if (count > 1) {
            int finalCount = count;
            source.m_288197_(() -> Component.m_237113_((String)"\u5f3a\u5236\u79fb\u9664 %s \u6548\u679c\u4ece %d \u4e2a\u5b9e\u4f53".formatted(effectName, finalCount)), true);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)("\u5f3a\u5236\u79fb\u9664 %s \u6548\u679c\u4e8e".formatted(effectName) + entityName)), true);
        }
        return count;
    }

    private static int removeAllEffects(CommandSourceStack source, Collection<? extends Entity> targets) {
        int count = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            for (MobEffect effect : living.m_21221_().keySet().toArray(new MobEffect[0])) {
                EffectUtils.forceRemoveEffect(living, effect);
            }
            ++count;
        }
        if (count == 0) {
            source.m_81352_((Component)Component.m_237113_((String)"\u6ca1\u6709\u6709\u6548\u7684\u751f\u7269\u5b9e\u4f53"));
            return 0;
        }
        int finalCount = count;
        source.m_288197_(() -> Component.m_237113_((String)"\u5f3a\u5236\u79fb\u9664\u6240\u6709\u6548\u679c\u4ece %d \u4e2a\u5b9e\u4f53".formatted(finalCount)), true);
        return count;
    }
}

