/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.yixixun.more_potion_effects.api.PotionBrewingSystem;

@JeiPlugin
public class MorePotionEffectsJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("more_potion_effects", "main");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List list;
        ItemStack output;
        ArrayList<IJeiBrewingRecipe> brewingRecipes = new ArrayList<IJeiBrewingRecipe>();
        for (PotionBrewingSystem.IngredientBrewingRecipe ingredientBrewingRecipe : PotionBrewingSystem.getRegisteredIngredientRecipes()) {
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            for (Item potionItem : new Item[]{Items.f_42589_, Items.f_42736_, Items.f_42739_}) {
                ItemStack input = PotionBrewingSystem.getGeneratedPotionStacks().stream().filter(stack -> stack.m_41720_() == potionItem && stack.m_41784_().m_128441_("BasePotion") && stack.m_41784_().m_128461_("BasePotion").equals(ingredientBrewingRecipe.basePotionId())).findFirst().orElse(ItemStack.f_41583_);
                if (input.m_41619_()) {
                    if (ingredientBrewingRecipe.basePotion().equals(Potions.f_43602_)) {
                        ItemStack awkwardPotion = new ItemStack((ItemLike)potionItem);
                        PotionUtils.m_43549_((ItemStack)awkwardPotion, (Potion)Potions.f_43602_);
                        inputs.add(awkwardPotion);
                        continue;
                    }
                    if (ingredientBrewingRecipe.basePotion().equals(Potions.f_43599_)) {
                        ItemStack waterPotion = new ItemStack((ItemLike)potionItem);
                        PotionUtils.m_43549_((ItemStack)waterPotion, (Potion)Potions.f_43599_);
                        inputs.add(waterPotion);
                        continue;
                    }
                    if (ingredientBrewingRecipe.basePotion().equals(Potions.f_43600_)) {
                        ItemStack mundanePotion = new ItemStack((ItemLike)potionItem);
                        PotionUtils.m_43549_((ItemStack)mundanePotion, (Potion)Potions.f_43600_);
                        inputs.add(mundanePotion);
                        continue;
                    }
                    if (!ingredientBrewingRecipe.basePotion().equals(Potions.f_43601_)) continue;
                    ItemStack thickPotion = new ItemStack((ItemLike)potionItem);
                    PotionUtils.m_43549_((ItemStack)thickPotion, (Potion)Potions.f_43601_);
                    inputs.add(thickPotion);
                    continue;
                }
                inputs.add(input);
            }
            if (inputs.isEmpty() || ingredientBrewingRecipe.ingredient().m_43908_().length <= 0) continue;
            output = ingredientBrewingRecipe.outputTemplate().m_41777_();
            ItemStack ingredient = ingredientBrewingRecipe.ingredient().m_43908_()[0];
            IJeiBrewingRecipe brewingRecipe = registration.getVanillaRecipeFactory().createBrewingRecipe(List.of(ingredient), inputs, output);
            brewingRecipes.add(brewingRecipe);
        }
        List potionInputs = PotionBrewingSystem.getGeneratedPotionStacks().stream().toList();
        if (!potionInputs.isEmpty()) {
            for (ItemStack input : potionInputs) {
                output = PotionBrewingSystem.gunpowderConversion(input);
                IJeiBrewingRecipe gunpowderRecipe = registration.getVanillaRecipeFactory().createBrewingRecipe(List.of(new ItemStack((ItemLike)Items.f_42403_)), List.of(input), output);
                brewingRecipes.add(gunpowderRecipe);
            }
        }
        if (!(list = PotionBrewingSystem.getGeneratedPotionStacks().stream().toList()).isEmpty()) {
            for (ItemStack input : list) {
                ItemStack output2 = PotionBrewingSystem.dragonBreathConversion(input);
                IJeiBrewingRecipe dragonBreathRecipe = registration.getVanillaRecipeFactory().createBrewingRecipe(List.of(new ItemStack((ItemLike)Items.f_42735_)), List.of(input), output2);
                brewingRecipes.add(dragonBreathRecipe);
            }
        }
        registration.addRecipes(RecipeTypes.BREWING, brewingRecipes);
    }
}

