/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.potion;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.yixixun.more_potion_effects.configuration.MPEconfigConfiguration;

public class ConfusionMobEffect
extends MobEffect {
    private static final double BASE_RESISTANCE = (double)0.2f;
    private static final double RESISTANCE_PER_LEVEL = (Double)MPEconfigConfiguration.RESISTANCE_PER_LEVEL.get();
    private static final double BASE_RANDOMNESS = (Double)MPEconfigConfiguration.BASE_RANDOMNESS.get();
    private static final double RANDOMNESS_PER_LEVEL = (Double)MPEconfigConfiguration.RANDOMNESS_PER_LEVEL.get();
    private static final double MAX_RESISTANCE = (double)0.95f;
    private static final double VERTICAL_REDUCTION = (double)0.4f;
    private static final int ROTATION_INTERVAL_BASE = 15;
    private static final int ROTATION_INTERVAL_REDUCTION_PER_LEVEL = (int)Math.round((Double)MPEconfigConfiguration.ROTATION_INTERVAL_REDUCTION_PER_LEVEL.get());

    public ConfusionMobEffect() {
        super(MobEffectCategory.HARMFUL, -10092391);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity.m_20184_().m_82556_() < 1.0E-4) {
            return;
        }
        float strength = this.calculateEffectStrength(amplifier);
        this.applyMovementResistance(entity, strength);
        this.applyDirectionalInterference(entity, amplifier, strength);
    }

    private float calculateEffectStrength(int amplifier) {
        return Mth.m_14036_((float)((float)(amplifier + 1) / 3.0f), (float)0.0f, (float)1.0f);
    }

    private void applyMovementResistance(LivingEntity entity, float strength) {
        double resistanceFactor = (double)0.2f + RESISTANCE_PER_LEVEL * (double)strength;
        resistanceFactor = Mth.m_14008_((double)resistanceFactor, (double)0.0, (double)0.95f);
        Vec3 motion = entity.m_20184_();
        double horizontalFactor = 1.0 - resistanceFactor;
        Vec3 newMotion = new Vec3(motion.m_7096_() * horizontalFactor, motion.m_7098_(), motion.m_7094_() * horizontalFactor);
        entity.m_20256_(newMotion);
    }

    private void applyDirectionalInterference(LivingEntity entity, int amplifier, float strength) {
        double randomness = BASE_RANDOMNESS + RANDOMNESS_PER_LEVEL * (double)strength;
        Vec3 motion = entity.m_20184_();
        RandomSource random = entity.m_217043_();
        double randX = (random.m_188500_() - 0.5) * 2.0 * randomness;
        double randY = (random.m_188500_() - 0.5) * 2.0 * randomness * (double)0.4f;
        double randZ = (random.m_188500_() - 0.5) * 2.0 * randomness;
        Vec3 newMotion = new Vec3(motion.m_7096_() + randX, motion.m_7098_() + randY, motion.m_7094_() + randZ);
        entity.m_20256_(newMotion);
        if (amplifier >= 2) {
            this.applyRotationInterference(entity, amplifier, strength);
        }
    }

    private void applyRotationInterference(LivingEntity entity, int amplifier, float strength) {
        int rotationTimer = entity.getPersistentData().m_128451_("confusion_rotation_timer");
        int interval = Math.max(1, 15 - amplifier * ROTATION_INTERVAL_REDUCTION_PER_LEVEL);
        if (++rotationTimer < interval) {
            entity.getPersistentData().m_128405_("confusion_rotation_timer", rotationTimer);
            return;
        }
        entity.getPersistentData().m_128405_("confusion_rotation_timer", 0);
        RandomSource random = entity.m_217043_();
        float rotationChange = (random.m_188501_() - 0.5f) * 30.0f * strength;
        entity.m_146922_(entity.m_146908_() + rotationChange);
        entity.m_146926_(Mth.m_14036_((float)(entity.m_146909_() + (random.m_188501_() - 0.5f) * 15.0f * strength), (float)-180.0f, (float)180.0f));
        entity.f_19859_ = entity.m_146908_();
        entity.f_19860_ = entity.m_146909_();
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

