/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.potion;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.yixixun.more_potion_effects.configuration.MPEconfigConfiguration;
import net.yixixun.more_potion_effects.init.MorePotionEffectsModMobEffects;

public class RankMobEffect
extends MobEffect {
    private static final int MAX_RANK = 6;
    private static final int WEAKENED_EFFECT_DURATION = 60;
    private static final double WEAKENED_EFFECT_FACTOR = 0.5;
    private static final int PARTICLE_INTERVAL = 5;
    private static final double BASE_RADIUS = 0.8;
    private static final double HEIGHT_OFFSET = 0.1;
    private static final double HALF_HEIGHT_MULTIPLIER = 0.75;
    private static final double RANK_RADIUS_FACTOR = 0.2;
    private static final int BASE_PARTICLE_COUNT = 10;
    private static final int HALO_BASE_PARTICLES = 8;
    private static final double SPIN_SPEED_FACTOR = 0.02;
    private static final double PARTICLE_VELOCITY_FACTOR = 0.05;
    private static final double HEAL_FACTOR = 0.5;
    private static final ParticleOptions[][] RANK_PARTICLES = new ParticleOptions[][]{{ParticleTypes.f_175830_, ParticleTypes.f_175827_}, {ParticleTypes.f_175830_, ParticleTypes.f_175827_, ParticleTypes.f_235898_}, {ParticleTypes.f_175830_, ParticleTypes.f_175827_, ParticleTypes.f_235898_, ParticleTypes.f_123789_}, {ParticleTypes.f_175830_, ParticleTypes.f_175827_, ParticleTypes.f_235898_, ParticleTypes.f_123789_, ParticleTypes.f_123799_}, {ParticleTypes.f_175830_, ParticleTypes.f_175827_, ParticleTypes.f_235898_, ParticleTypes.f_123789_, ParticleTypes.f_123799_, ParticleTypes.f_123810_}, {ParticleTypes.f_175830_, ParticleTypes.f_175827_, ParticleTypes.f_235898_, ParticleTypes.f_123789_, ParticleTypes.f_123799_, ParticleTypes.f_123810_, ParticleTypes.f_123815_}};
    private static final Map<Integer, AttributeModifiers> ATTRIBUTE_MODIFIERS = Map.of(1, new AttributeModifiers(2.0, 4.0, 1.1, 1.5, 1.2, 0.5), 2, new AttributeModifiers(3.0, 6.0, 1.25, 2.0, 1.35, 0.75), 3, new AttributeModifiers(5.0, 10.0, 1.5, 3.5, 1.5, 0.8), 4, new AttributeModifiers(7.5, 15.0, 2.0, 5.0, 1.7, 0.9), 5, new AttributeModifiers(10.0, 20.0, 3.0, 7.0, 2.0, 0.95), 6, new AttributeModifiers(20.0, 40.0, 5.0, 10.0, 3.0, 0.99));

    public RankMobEffect() {
        super(MobEffectCategory.BENEFICIAL, -10092442);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        int rankLevel = Math.min(amplifier + 1, 6);
        if (entity instanceof Player) {
            entity.m_5634_((float)(0.5 * (double)entity.m_21233_()));
        } else {
            this.updateEntityName(entity, rankLevel);
            this.applyAttributeModifiers(entity, attributeMap, rankLevel, true);
            if (((Boolean)MPEconfigConfiguration.RANK_EFFECTS.get()).booleanValue()) {
                this.applyRandomEffects(entity, amplifier);
            }
        }
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level world = entity.m_9236_();
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        this.applyNegativeEffectsToTarget(entity, amplifier);
        this.applyAreaNegativeEffects((LevelAccessor)world, x, y, z, entity, amplifier);
        this.applySelfEffects((LevelAccessor)world, x, y, z, entity, amplifier);
        this.applyWeakenedBuffsToSameType((LevelAccessor)world, x, y, z, entity, amplifier);
        if (entity.f_19797_ % 5 == 0) {
            this.sendRankParticles((LevelAccessor)world, x, y + (double)entity.m_20206_() * 0.75, z, amplifier);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        int rankLevel = Math.min(amplifier + 1, 6);
        if (!(entity instanceof Player)) {
            this.restoreEntityName(entity, rankLevel);
            this.applyAttributeModifiers(entity, attributeMap, rankLevel, false);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 5 == 0;
    }

    private void updateEntityName(LivingEntity entity, int rankLevel) {
        entity.m_6593_((Component)Component.m_237113_((String)(Component.m_237115_((String)("rank_entity_title_" + rankLevel)).getString() + entity.m_5446_().getString())));
    }

    private void restoreEntityName(LivingEntity entity, int rankLevel) {
        String displayName;
        String title = Component.m_237115_((String)("rank_entity_title_" + rankLevel)).getString();
        Component customName = entity.m_7770_();
        if (customName != null && (displayName = customName.getString()).startsWith(title)) {
            entity.m_6593_((Component)Component.m_237113_((String)displayName.substring(title.length())));
            entity.m_20340_(false);
        }
    }

    private int getRankLevel(LivingEntity entity) {
        if (entity == null) {
            return -1;
        }
        MobEffectInstance effect = entity.m_21124_((MobEffect)MorePotionEffectsModMobEffects.RANK.get());
        return effect != null ? effect.m_19564_() : -1;
    }

    private void applyNegativeEffectsToTarget(LivingEntity entity, int amplifier) {
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        LivingEntity target = mob.m_5448_();
        if (target == null) {
            return;
        }
        int targetRank = this.getRankLevel(target);
        if (targetRank == -1) {
            return;
        }
        double maxDistance = (amplifier + 1) * 2 + 6;
        double distance = entity.m_20270_((Entity)target);
        if (targetRank < amplifier && distance <= maxDistance) {
            this.applyNegativeEffects(target, amplifier - targetRank);
        }
    }

    private void applyAreaNegativeEffects(LevelAccessor world, double x, double y, double z, LivingEntity entity, int amplifier) {
        double radius = (double)((amplifier + 1) * 2 + 4) / 2.0;
        AABB area = new AABB(x, y, z, x, y, z).m_82400_(radius);
        EntityType sourceType = entity.m_6095_();
        for (LivingEntity livingEntity : world.m_45976_(LivingEntity.class, area)) {
            if (livingEntity == entity || livingEntity.m_6095_() == sourceType || this.getRankLevel(livingEntity) >= amplifier) continue;
            int otherRank = this.getRankLevel(livingEntity);
            this.applyNegativeEffects(livingEntity, amplifier - otherRank);
        }
    }

    private void applySelfEffects(LevelAccessor world, double x, double y, double z, LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.applyPlayerEffects((LivingEntity)player, amplifier);
        } else {
            this.applyNonPlayerEffects(entity, amplifier);
        }
    }

    private void applyWeakenedBuffsToSameType(LevelAccessor world, double x, double y, double z, LivingEntity source, int amplifier) {
        if (amplifier < 1) {
            return;
        }
        double radius = (double)(amplifier + 3) / 2.0;
        AABB area = new AABB(x, y, z, x, y, z).m_82400_(radius);
        EntityType sourceType = source.m_6095_();
        for (LivingEntity livingEntity : world.m_45976_(LivingEntity.class, area)) {
            if (livingEntity == source || livingEntity.m_6095_() != sourceType || this.getRankLevel(livingEntity) >= 0) continue;
            this.applyWeakenedEffects(livingEntity, amplifier);
        }
    }

    private void applyAttributeModifiers(LivingEntity entity, AttributeMap attributeMap, int rankLevel, boolean apply) {
        AttributeModifiers mods = ATTRIBUTE_MODIFIERS.getOrDefault(rankLevel, ATTRIBUTE_MODIFIERS.get(1));
        HashMultimap modifiers = HashMultimap.create();
        this.addAttributeModifier((Multimap<Attribute, AttributeModifier>)modifiers, Attributes.f_22276_, "rank_health", mods.health, AttributeModifier.Operation.ADDITION);
        this.addAttributeModifier((Multimap<Attribute, AttributeModifier>)modifiers, Attributes.f_22284_, "rank_armor", mods.armor, AttributeModifier.Operation.ADDITION);
        this.addAttributeModifier((Multimap<Attribute, AttributeModifier>)modifiers, Attributes.f_22285_, "rank_toughness", mods.armor, AttributeModifier.Operation.ADDITION);
        this.addAttributeModifier((Multimap<Attribute, AttributeModifier>)modifiers, Attributes.f_22283_, "rank_attack_speed", mods.attackSpeed - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.addAttributeModifier((Multimap<Attribute, AttributeModifier>)modifiers, Attributes.f_22281_, "rank_attack_damage", mods.attack - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.addAttributeModifier((Multimap<Attribute, AttributeModifier>)modifiers, Attributes.f_22279_, "rank_movement", mods.movement - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.addAttributeModifier((Multimap<Attribute, AttributeModifier>)modifiers, Attributes.f_22278_, "rank_knockback", mods.knockback, AttributeModifier.Operation.ADDITION);
        if (apply) {
            attributeMap.m_22178_((Multimap)modifiers);
            entity.m_21153_(entity.m_21233_());
        } else {
            attributeMap.m_22161_((Multimap)modifiers);
        }
    }

    private void addAttributeModifier(Multimap<Attribute, AttributeModifier> modifiers, Attribute attribute, String name, double value, AttributeModifier.Operation operation) {
        UUID uuid = UUID.nameUUIDFromBytes((name + attribute.m_22087_()).getBytes());
        modifiers.put((Object)attribute, (Object)new AttributeModifier(uuid, name, value, operation));
    }

    private void applyRandomEffects(LivingEntity entity, int amplifier) {
        int level = Math.max(amplifier - 1, 0);
        List<MobEffectInstance> effectPool = this.createEffectPool(level);
        int effectCount = Math.min(amplifier + 1, 13);
        RandomSource random = RandomSource.m_216327_();
        HashSet<MobEffectInstance> chosenEffects = new HashSet<MobEffectInstance>();
        while (chosenEffects.size() < effectCount && !effectPool.isEmpty()) {
            chosenEffects.add(effectPool.get(random.m_188503_(effectPool.size())));
        }
        chosenEffects.forEach(arg_0 -> ((LivingEntity)entity).m_7292_(arg_0));
    }

    private List<MobEffectInstance> createEffectPool(int level) {
        List<Supplier> effects = List.of(MorePotionEffectsModMobEffects.LEECHING, MorePotionEffectsModMobEffects.SOLID_SHIELD, MorePotionEffectsModMobEffects.EVASION, MorePotionEffectsModMobEffects.ASYLUM, MorePotionEffectsModMobEffects.ADAPTATION, MorePotionEffectsModMobEffects.HUGE_FORCE, MorePotionEffectsModMobEffects.IMMORTAL, MorePotionEffectsModMobEffects.INJURY_LINK, MorePotionEffectsModMobEffects.IMMUNE, MorePotionEffectsModMobEffects.INJURY_LIMITATION, MorePotionEffectsModMobEffects.SELF_HEALING, MorePotionEffectsModMobEffects.SLAUGHTER, () -> MobEffects.f_19605_, () -> MobEffects.f_19607_, () -> MobEffects.f_19609_, () -> MobEffects.f_19606_, () -> MobEffects.f_19596_, () -> MobEffects.f_19600_, () -> MobEffects.f_19616_, () -> MobEffects.f_19608_, () -> MobEffects.f_19621_, MorePotionEffectsModMobEffects.MAGIC_SHIELD, MorePotionEffectsModMobEffects.MAGIC_FOCUS, MorePotionEffectsModMobEffects.OVERDOSE_TREATMENT, MorePotionEffectsModMobEffects.ACCURATE);
        ArrayList<MobEffectInstance> pool = new ArrayList<MobEffectInstance>(effects.size());
        for (Supplier effectSupplier : effects) {
            pool.add(new MobEffectInstance((MobEffect)effectSupplier.get(), 2000000, level, false, false));
        }
        return pool;
    }

    private void applyNegativeEffects(LivingEntity target, int level) {
        if (level < 0) {
            return;
        }
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, level, false, false));
        target.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.FRAGILE.get(), 60, level, false, false));
        target.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.FEAR.get(), 60, level, false, false));
        target.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.MISALIGNMENT.get(), 60, level, false, false));
    }

    private void applyWeakenedEffects(LivingEntity target, int sourceAmplifier) {
        int weakenedLevel = (int)Math.max(0.0, (double)sourceAmplifier * 0.5);
        target.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.SELF_HEALING.get(), 60, weakenedLevel, false, false));
        target.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.STEP_UP.get(), 60, weakenedLevel, false, false));
        target.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.BLEEDING_IMMUNITY.get(), 60, weakenedLevel, false, false));
        if (sourceAmplifier > 1) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, weakenedLevel, false, false));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, weakenedLevel, false, false));
        }
    }

    private void applyPlayerEffects(LivingEntity player, int amplifier) {
        int roundedLevel = (int)Math.round((double)amplifier * 0.5);
        player.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.SELF_HEALING.get(), 60, roundedLevel, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60, roundedLevel, false, false));
        player.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.STEP_UP.get(), 60, roundedLevel, false, false));
        player.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.BLEEDING_IMMUNITY.get(), 60, roundedLevel, false, false));
        player.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.SOLID_SHIELD.get(), 60, amplifier, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, amplifier, false, false));
        player.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.ACCURATE.get(), 60, amplifier, false, false));
        player.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.LEECHING.get(), 60, amplifier, false, false));
    }

    private void applyNonPlayerEffects(LivingEntity entity, int amplifier) {
        int roundedLevel = (int)Math.round((double)amplifier * 0.5);
        entity.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.SELF_HEALING.get(), 60, roundedLevel, false, false));
        entity.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.STEP_UP.get(), 60, roundedLevel, false, false));
        entity.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.BLEEDING_IMMUNITY.get(), 60, roundedLevel, false, false));
    }

    private void sendRankParticles(LevelAccessor world, double x, double y, double z, int amplifier) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        int rankLevel = Math.min(amplifier + 1, 6);
        int tier = Math.min(rankLevel - 1, RANK_PARTICLES.length - 1);
        if (tier < 0) {
            return;
        }
        RandomSource random = RandomSource.m_216327_();
        double radius = 0.8 + (double)rankLevel * 0.2;
        int particleCount = 10 + rankLevel * 5;
        this.generateBaseParticles(serverLevel, x, y, z, rankLevel, tier, random, radius, particleCount);
        if (rankLevel >= 3) {
            this.generateHaloParticles(serverLevel, x, y, z, rankLevel, radius);
        }
        if (rankLevel >= 4) {
            this.generateCoreParticles(serverLevel, x, y, z, rankLevel, random);
        }
    }

    private void generateBaseParticles(ServerLevel serverLevel, double x, double y, double z, int rankLevel, int tier, RandomSource random, double radius, int particleCount) {
        for (int i = 0; i < particleCount; ++i) {
            ParticleOptions type = RANK_PARTICLES[tier][random.m_188503_(RANK_PARTICLES[tier].length)];
            double angle = random.m_188500_() * Math.PI * 2.0;
            double distance = radius * (0.7 + random.m_188500_() * 0.3);
            double px = x + Math.cos(angle) * distance;
            double pz = z + Math.sin(angle) * distance;
            double py = y + 0.1 + (random.m_188500_() - 0.5) * 0.5;
            double vx = 0.0;
            double vy = 0.05 + random.m_188500_() * 0.05;
            double vz = 0.0;
            if (rankLevel >= 4) {
                double spinSpeed = 0.02 * (double)rankLevel;
                vx = -Math.sin(angle) * spinSpeed;
                vz = Math.cos(angle) * spinSpeed;
                if (random.m_188500_() < 0.3) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175826_, px, py, pz, 1, 0.0, 0.0, 0.0, 0.1);
                }
            }
            if (rankLevel >= 6) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, px, py, pz, 0, vx * 0.5, vy * 0.5, vz * 0.5, 0.1);
                if (random.m_188500_() < 0.2) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123815_, px, py + 0.2, pz, 3, 0.1, 0.1, 0.1, 0.05);
                }
            }
            serverLevel.m_8767_(type, px, py, pz, 1, vx, vy, vz, 0.5);
        }
    }

    private void generateHaloParticles(ServerLevel serverLevel, double x, double y, double z, int rankLevel, double radius) {
        int haloParticles = 8 + rankLevel * 2;
        double haloRadius = radius * 1.2;
        double haloHeight = y + 0.1 + 0.5;
        SimpleParticleType particle = rankLevel >= 5 ? ParticleTypes.f_123799_ : ParticleTypes.f_175827_;
        for (int i = 0; i < haloParticles; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)haloParticles;
            double px = x + Math.cos(angle) * haloRadius;
            double pz = z + Math.sin(angle) * haloRadius;
            serverLevel.m_8767_((ParticleOptions)particle, px, haloHeight, pz, 1, 0.0, -0.01, 0.0, 0.05);
        }
    }

    private void generateCoreParticles(ServerLevel serverLevel, double x, double y, double z, int rankLevel, RandomSource random) {
        int coreParticles = 3 + rankLevel;
        for (int i = 0; i < coreParticles; ++i) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, x, y + 0.1, z, 1, (random.m_188500_() - 0.5) * 0.05, (random.m_188500_() - 0.5) * 0.05, (random.m_188500_() - 0.5) * 0.05, 0.2);
        }
    }

    private record AttributeModifiers(double health, double armor, double attackSpeed, double attack, double movement, double knockback) {
    }
}

