/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.procedures;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.yixixun.more_potion_effects.MorePotionEffectsMod;
import net.yixixun.more_potion_effects.configuration.MPEconfigConfiguration;
import net.yixixun.more_potion_effects.init.MorePotionEffectsModMobEffects;
import net.yixixun.more_potion_effects.network.MorePotionEffectsModVariables;

@Mod.EventBusSubscriber
public class SpawnPotionEntityProcedure {
    private static Map<String, Integer> rankEntityCache = new HashMap<String, Integer>();
    private static Map<Integer, Double> rankSpawnPossibilityCache = new HashMap<Integer, Double>();
    private static final Map<Integer, Double> defaultSpawnPossibilityCache = Map.of(1, 0.05, 2, 0.025, 3, 0.005, 4, 0.001, 5, 1.0E-4, 6, 1.0E-5);

    @SubscribeEvent
    public static void onEntitySpawned(EntityJoinLevelEvent event) {
        SpawnPotionEntityProcedure.execute((Event)event, (LevelAccessor)event.getLevel(), event.getEntity());
    }

    @SubscribeEvent
    public static void onGameLoad(FMLLoadCompleteEvent event) {
        SpawnPotionEntityProcedure.parseConfigurations();
    }

    public static void execute(LevelAccessor world, Entity entity) {
        SpawnPotionEntityProcedure.execute(null, world, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, Entity entity) {
        if (entity == null) {
            return;
        }
        String entityType = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString();
        boolean ban = ((List)MPEconfigConfiguration.NO_RANK_ENTITY.get()).contains(entityType);
        if (!ban) {
            int level;
            Integer fixedRank = rankEntityCache.get(entityType);
            if (fixedRank != null) {
                SpawnPotionEntityProcedure.applyRankEffect(entity, fixedRank);
                return;
            }
            if (SpawnPotionEntityProcedure.shouldApplyRandomRank(world) && (level = SpawnPotionEntityProcedure.determineRandomRankLevel()) > 0 && SpawnPotionEntityProcedure.canApplyRank(world, entity, level)) {
                SpawnPotionEntityProcedure.applyRankEffect(entity, level);
                SpawnPotionEntityProcedure.scheduleCooldownReset(world, level);
            }
        }
    }

    private static void parseConfigurations() {
        int rank;
        String[] parts;
        rankEntityCache.clear();
        for (String entry : (List)MPEconfigConfiguration.RANK_ENTITY.get()) {
            try {
                String[] entities;
                parts = entry.split("->", 2);
                if (parts.length != 2) continue;
                rank = Integer.parseInt(parts[0].trim());
                for (String entity : entities = parts[1].split(",")) {
                    rankEntityCache.put(entity.trim(), rank);
                }
            }
            catch (Exception e) {
                MorePotionEffectsMod.LOGGER.error("Invalid RANK_ENTITY entry: {}", (Object)entry, (Object)e);
            }
        }
        rankSpawnPossibilityCache.clear();
        if (MPEconfigConfiguration.RANK_SPAWN_POSSIBILITY.get() != null) {
            for (String entry : (List)MPEconfigConfiguration.RANK_SPAWN_POSSIBILITY.get()) {
                try {
                    parts = entry.split(":", 2);
                    if (parts.length != 2) continue;
                    rank = Integer.parseInt(parts[0].trim());
                    double possibility = Double.parseDouble(parts[1].trim());
                    rankSpawnPossibilityCache.put(rank, possibility);
                }
                catch (Exception e) {
                    MorePotionEffectsMod.LOGGER.error("Invalid RANK_SPAWN_POSSIBILITY entry: {}", (Object)entry, (Object)e);
                }
            }
        } else {
            rankSpawnPossibilityCache.putAll(defaultSpawnPossibilityCache);
        }
    }

    private static void applyRankEffect(Entity entity, int rank) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_9236_().m_5776_()) {
            int duration = 48000 * rank;
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.RANK.get(), duration, rank, false, false));
        }
    }

    private static boolean shouldApplyRandomRank(LevelAccessor world) {
        return (Double)MPEconfigConfiguration.MAX_RANK_LEVEL.get() > 0.0 && !MorePotionEffectsModVariables.MapVariables.get((LevelAccessor)world).rank_cooldown && MorePotionEffectsModVariables.MapVariables.get((LevelAccessor)world).rank_entity_exist <= (Double)MPEconfigConfiguration.MAX_RANK_EXIST.get() - 3.0;
    }

    private static int determineRandomRankLevel() {
        int level = 0;
        double num = (double)Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)10000) / 100.0;
        for (int i = 6; i >= 1; --i) {
            Double possibility = rankSpawnPossibilityCache.get(i);
            if (possibility == null || !(num <= possibility)) continue;
            level = i;
            break;
        }
        return (int)Math.min((double)level, (Double)MPEconfigConfiguration.MAX_RANK_LEVEL.get());
    }

    private static boolean canApplyRank(LevelAccessor world, Entity entity, int level) {
        return level >= 1 && !(entity instanceof Player) && MorePotionEffectsModVariables.MapVariables.get((LevelAccessor)world).rank_entity_exist + Math.pow(3.0, level) <= (Double)MPEconfigConfiguration.MAX_RANK_EXIST.get();
    }

    private static void scheduleCooldownReset(LevelAccessor world, int level) {
        MorePotionEffectsModVariables.MapVariables.get((LevelAccessor)world).rank_cooldown = true;
        MorePotionEffectsModVariables.MapVariables.get(world).syncData(world);
        MorePotionEffectsMod.queueServerWork(2 * level, () -> {
            MorePotionEffectsModVariables.MapVariables.get((LevelAccessor)world).rank_cooldown = false;
            MorePotionEffectsModVariables.MapVariables.get(world).syncData(world);
        });
    }
}

