/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.yixixun.more_potion_effects.api.EffectUtils;
import net.yixixun.more_potion_effects.configuration.MPEconfigConfiguration;
import net.yixixun.more_potion_effects.init.MorePotionEffectsModMobEffects;
import net.yixixun.more_potion_effects.network.MorePotionEffectsModVeiledPresence;
import net.yixixun.more_potion_effects.procedures.Immune_AbilityProcedure;

@Mod.EventBusSubscriber
public class EffectEvent {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityAddEffect(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance newEffect = event.getEffectInstance();
        EffectEvent.handleExtensionEffect(entity, newEffect);
        EffectEvent.handleDispelOnAdd(entity, newEffect);
    }

    private static void handleExtensionEffect(LivingEntity entity, MobEffectInstance newEffect) {
        if (entity.m_21023_((MobEffect)MorePotionEffectsModMobEffects.EXTENSION.get()) && (Double)MPEconfigConfiguration.EXTENSION_METHOD.get() == 0.0) {
            int extensionLevel = entity.m_21124_((MobEffect)MorePotionEffectsModMobEffects.EXTENSION.get()).m_19564_() + 1;
            int extraDuration = 600 * extensionLevel;
            if (!newEffect.m_19544_().m_8093_()) {
                newEffect.m_19558_(new MobEffectInstance(newEffect.m_19544_(), newEffect.m_19557_() + 600 + extraDuration, newEffect.m_19564_()));
            } else {
                newEffect.m_19558_(new MobEffectInstance(newEffect.m_19544_(), newEffect.m_19557_() + extensionLevel, newEffect.m_19564_()));
            }
        }
    }

    private static void handleDispelOnAdd(LivingEntity entity, MobEffectInstance newEffect) {
        if (newEffect.m_19544_() == MorePotionEffectsModMobEffects.DISPEL.get()) {
            int dispelLevel = newEffect.m_19564_();
            List<MobEffectInstance> effectsToProcess = entity.m_21220_().stream().filter(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL).filter(effect -> effect.m_19544_() != MorePotionEffectsModMobEffects.DISPEL.get()).toList();
            for (MobEffectInstance effect2 : effectsToProcess) {
                int newLevel = effect2.m_19564_() - dispelLevel;
                if (newLevel >= 0) {
                    entity.m_21195_(effect2.m_19544_());
                    entity.m_7292_(new MobEffectInstance(effect2.m_19544_(), effect2.m_19557_(), newLevel, effect2.m_19571_(), effect2.m_19572_(), effect2.m_19575_()));
                    continue;
                }
                entity.m_21195_(effect2.m_19544_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onApplicable(MobEffectEvent.Applicable event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance effectToApply = event.getEffectInstance();
        CompoundTag persistentData = entity.getPersistentData();
        String effectId = Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effectToApply.m_19544_())).toString();
        String entityId = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())).toString();
        if (persistentData.m_128471_("dispelling_in_progress") || persistentData.m_128471_("Upgrading")) {
            return;
        }
        if (entity.m_21023_((MobEffect)MorePotionEffectsModMobEffects.IMMUNE.get()) && Immune_AbilityProcedure.getImmuneEffects(entity).contains(effectToApply.m_19544_())) {
            event.setResult(Event.Result.DENY);
        }
        if (((List)MPEconfigConfiguration.FORCE_EFFECTS.get()).contains(effectId) && !((List)MPEconfigConfiguration.BAN_LIST.get()).contains(effectId)) {
            EffectUtils.forceAddEffect(entity, effectToApply, null);
            event.setResult(Event.Result.ALLOW);
        }
        if (((List)MPEconfigConfiguration.ENTITY_LIST.get()).contains(entityId)) {
            event.setResult(Event.Result.ALLOW);
        }
        if (entity.m_21023_((MobEffect)MorePotionEffectsModMobEffects.DISPEL.get()) && effectToApply.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL && !effectToApply.m_19544_().equals(MorePotionEffectsModMobEffects.DISPEL.get())) {
            int dispelLevel = entity.m_21124_((MobEffect)MorePotionEffectsModMobEffects.DISPEL.get()).m_19564_();
            int newLevel = effectToApply.m_19564_() - dispelLevel;
            event.setResult(Event.Result.DENY);
            if (newLevel >= 0) {
                persistentData.m_128379_("dispelling_in_progress", true);
                entity.m_7292_(new MobEffectInstance(effectToApply.m_19544_(), effectToApply.m_19557_(), newLevel, effectToApply.m_19571_(), effectToApply.m_19572_(), effectToApply.m_19575_()));
                persistentData.m_128379_("dispelling_in_progress", false);
            }
        }
        if (effectToApply.m_19544_() == MorePotionEffectsModMobEffects.UPGRADE.get()) {
            int upgradeLevel = effectToApply.m_19564_();
            HashSet exclusionSet = new HashSet((Collection)MPEconfigConfiguration.UPGRADE_EXCLUSION.get());
            entity.m_21220_().stream().filter(e -> e.m_19544_() != MorePotionEffectsModMobEffects.UPGRADE.get()).filter(e -> e.m_19564_() < upgradeLevel).filter(e -> !exclusionSet.contains(Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)e.m_19544_())).toString())).forEach(effect -> {
                int newAmplifier = entity.m_217043_().m_216339_(effect.m_19564_() + 1, upgradeLevel + 1);
                effect.m_19558_(new MobEffectInstance(effect.m_19544_(), effect.m_19557_(), newAmplifier, effect.m_19571_(), effect.m_19572_(), effect.m_19575_()));
            });
            entity.m_21195_((MobEffect)MorePotionEffectsModMobEffects.UPGRADE.get());
        }
        if (((List)MPEconfigConfiguration.BAN_LIST.get()).contains(effectId)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityRemoveEffect(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        CompoundTag persistentData = entity.getPersistentData();
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance == null) {
            return;
        }
        EffectEvent.handleRankEffectRemoval(entity, effectInstance, event);
        EffectEvent.handleLockEffectRemoval(entity, persistentData, effectInstance, event);
    }

    private static void handleRankEffectRemoval(LivingEntity entity, MobEffectInstance effectInstance, MobEffectEvent.Remove event) {
        if (entity == null || effectInstance == null || event == null) {
            return;
        }
        if (event.getEffect() == MorePotionEffectsModMobEffects.RANK.get() && effectInstance.m_19557_() > 1) {
            int targetAmplifier = effectInstance.m_19564_() - 1;
            List<MobEffect> effectsToRemove = entity.m_21220_().stream().filter(e -> e != null && e.m_19564_() == targetAmplifier).map(MobEffectInstance::m_19544_).toList();
            effectsToRemove.forEach(arg_0 -> ((LivingEntity)entity).m_21195_(arg_0));
            entity.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.RANK.get(), effectInstance.m_19557_() / 2, effectInstance.m_19564_()));
        }
    }

    private static void handleLockEffectRemoval(LivingEntity entity, CompoundTag persistentData, MobEffectInstance effectInstance, MobEffectEvent.Remove event) {
        if (persistentData.m_128471_("locking_in_progress")) {
            return;
        }
        if (entity.m_21023_((MobEffect)MorePotionEffectsModMobEffects.LOCK.get())) {
            if (event.getEffect() != MorePotionEffectsModMobEffects.LOCK.get() && effectInstance.m_19557_() > 0) {
                event.setCanceled(true);
                return;
            }
            if (event.getEffect() == MorePotionEffectsModMobEffects.LOCK.get()) {
                if (effectInstance.m_19557_() <= 1) {
                    return;
                }
                event.setCanceled(true);
                persistentData.m_128379_("locking_in_progress", true);
                entity.m_21195_((MobEffect)MorePotionEffectsModMobEffects.LOCK.get());
                entity.m_7292_(new MobEffectInstance((MobEffect)MorePotionEffectsModMobEffects.LOCK.get(), (int)((double)effectInstance.m_19557_() - 1200.0 / ((double)effectInstance.m_19564_() + 1.0)), effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_()));
                persistentData.m_128379_("locking_in_progress", false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onLivingRenderPre(RenderLivingEvent.Pre<LivingEntity, ?> event) {
        LivingEntity entity = event.getEntity();
        entity.getCapability(MorePotionEffectsModVeiledPresence.ENTITY_VARIABLES_CAPABILITY).ifPresent(cap -> {
            if (cap.isVeiled) {
                event.setCanceled(true);
            }
        });
    }
}

