/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.api;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.yixixun.more_potion_effects.configuration.MPEconfigConfiguration;

@Mod.EventBusSubscriber
public class EffectUtils {
    private static final List<MobEffect> ALL_EFFECTS = new ArrayList<MobEffect>();
    private static final List<MobEffect> GOOD_EFFECTS = new ArrayList<MobEffect>();
    private static final List<MobEffect> BAD_EFFECTS = new ArrayList<MobEffect>();
    private static final Random RANDOM = new Random();
    private static Method METHOD_onEffectAdded;
    private static Method METHOD_onEffectUpdated;
    private static Method METHOD_onEffectRemoved;
    private static Field FIELD_effectsDirty;

    @SubscribeEvent
    public static void fillLists(LevelEvent.Load event) {
        Set exclusion = Stream.concat(((List)MPEconfigConfiguration.RANDOM_EFFECT_EXCLUSION.get()).stream(), ((List)MPEconfigConfiguration.BAN_LIST.get()).stream()).collect(Collectors.toSet());
        List<MobEffect> all = ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(e -> !exclusion.contains(ForgeRegistries.MOB_EFFECTS.getKey(e).toString())).toList();
        ALL_EFFECTS.clear();
        ALL_EFFECTS.addAll(all);
        GOOD_EFFECTS.clear();
        GOOD_EFFECTS.addAll(all.stream().filter(e -> e.m_19483_() == MobEffectCategory.BENEFICIAL).toList());
        BAD_EFFECTS.clear();
        BAD_EFFECTS.addAll(all.stream().filter(e -> e.m_19483_() == MobEffectCategory.HARMFUL).toList());
    }

    public static MobEffect getRandomGoodEffect() {
        return EffectUtils.getRandomFromList(GOOD_EFFECTS);
    }

    public static MobEffect getRandomBadEffect() {
        return EffectUtils.getRandomFromList(BAD_EFFECTS);
    }

    public static MobEffect getRandomAllEffect() {
        return EffectUtils.getRandomFromList(ALL_EFFECTS);
    }

    private static MobEffect getRandomFromList(List<MobEffect> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(RANDOM.nextInt(list.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceAddEffect(LivingEntity entity, MobEffectInstance effect, @Nullable Entity source) {
        if (entity == null || effect == null) {
            return;
        }
        MobEffectInstance existing = entity.m_21124_(effect.m_19544_());
        MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Added(entity, existing, effect, source));
        if (existing == null) {
            entity.m_21221_().put(effect.m_19544_(), effect);
            try {
                EffectUtils.invokeOnEffectAdded(entity, effect, source);
            }
            finally {
                EffectUtils.setEffectsDirty(entity);
            }
        }
        if (existing.m_19558_(effect)) {
            try {
                EffectUtils.invokeOnEffectUpdated(entity, existing, true, source);
            }
            finally {
                EffectUtils.setEffectsDirty(entity);
            }
        }
    }

    public static void forceRemoveEffect(LivingEntity entity, MobEffect effect) {
        if (entity == null || effect == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(entity, effect));
        MobEffectInstance removedEffect = (MobEffectInstance)entity.m_21221_().remove(effect);
        if (removedEffect != null) {
            try {
                EffectUtils.invokeOnEffectRemoved(entity, effect);
            }
            finally {
                EffectUtils.setEffectsDirty(entity);
            }
        }
    }

    private static void invokeOnEffectAdded(LivingEntity entity, MobEffectInstance effect, @Nullable Entity source) {
        if (METHOD_onEffectAdded == null) {
            return;
        }
        try {
            METHOD_onEffectAdded.invoke((Object)entity, effect, source);
        }
        catch (Exception e) {
            System.err.println("\u8c03\u7528 onEffectAdded \u5931\u8d25: " + e.getMessage());
        }
    }

    private static void invokeOnEffectUpdated(LivingEntity entity, MobEffectInstance effect, boolean flag, @Nullable Entity source) {
        if (METHOD_onEffectUpdated == null) {
            return;
        }
        try {
            METHOD_onEffectUpdated.invoke((Object)entity, effect, flag, source);
        }
        catch (Exception e) {
            System.err.println("\u8c03\u7528 onEffectUpdated \u5931\u8d25: " + e.getMessage());
        }
    }

    private static void invokeOnEffectRemoved(LivingEntity entity, MobEffect effect) {
        if (METHOD_onEffectRemoved == null) {
            return;
        }
        try {
            MobEffectInstance instance = (MobEffectInstance)entity.m_21221_().get(effect);
            if (instance != null) {
                METHOD_onEffectRemoved.invoke((Object)entity, instance);
            }
        }
        catch (Exception e) {
            System.err.println("\u8c03\u7528 onEffectRemoved \u5931\u8d25: " + e.getMessage());
        }
    }

    private static void setEffectsDirty(LivingEntity entity) {
        if (FIELD_effectsDirty == null) {
            return;
        }
        try {
            FIELD_effectsDirty.setBoolean(entity, true);
        }
        catch (Exception e) {
            System.err.println("\u8bbe\u7f6e effectsDirty \u5931\u8d25: " + e.getMessage());
        }
    }

    static {
        try {
            METHOD_onEffectAdded = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_142540_", (Class[])new Class[]{MobEffectInstance.class, Entity.class});
            METHOD_onEffectUpdated = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_141973_", (Class[])new Class[]{MobEffectInstance.class, Boolean.TYPE, Entity.class});
            METHOD_onEffectRemoved = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_7285_", (Class[])new Class[]{MobEffectInstance.class});
            FIELD_effectsDirty = ObfuscationReflectionHelper.findField(LivingEntity.class, (String)"f_20948_");
            Optional.ofNullable(METHOD_onEffectAdded).ifPresent(m -> m.setAccessible(true));
            Optional.ofNullable(METHOD_onEffectUpdated).ifPresent(m -> m.setAccessible(true));
            Optional.ofNullable(METHOD_onEffectRemoved).ifPresent(m -> m.setAccessible(true));
            Optional.ofNullable(FIELD_effectsDirty).ifPresent(f -> f.setAccessible(true));
        }
        catch (Exception e) {
            System.err.println("\u53cd\u5c04\u521d\u59cb\u5316\u5931\u8d25: " + e.getMessage());
        }
    }
}

