/*
 * Decompiled with CFR 0.152.
 */
package net.yixixun.more_potion_effects.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.yixixun.more_potion_effects.MorePotionEffectsMod;
import net.yixixun.more_potion_effects.api.EffectUtils;
import net.yixixun.more_potion_effects.configuration.MPEconfigConfiguration;
import net.yixixun.more_potion_effects.init.MorePotionEffectsModMobEffects;
import net.yixixun.more_potion_effects.potion.VeiledPresenceMobEffect;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class MPEEvent {
    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingChangeTargetEvent event) {
        if (event.getNewTarget() != null && !VeiledPresenceMobEffect.canAttack(event.getEntity(), event.getNewTarget())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityAttacked(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        LivingEntity attacker = source.m_7639_() instanceof LivingEntity ? (LivingEntity)source.m_7639_() : null;
        LivingEntity target = event.getEntity();
        float damage = event.getAmount();
        if (attacker == null || target == null) {
            return;
        }
        VeiledPresenceMobEffect.onAttack(attacker, target);
        MPEEvent.handleEffectSiphon(attacker, target);
        MPEEvent.handleEffectAoe(attacker, target, source, damage);
    }

    private static void handleEffectSiphon(LivingEntity attacker, LivingEntity target) {
        if (attacker.m_21023_((MobEffect)MorePotionEffectsModMobEffects.EFFECT_SIPHON.get()) && !target.m_21023_((MobEffect)MorePotionEffectsModMobEffects.LOCK.get())) {
            Player player;
            CompoundTag attackerData = attacker.getPersistentData();
            if (attacker instanceof Player && (player = (Player)attacker).m_36403_(0.5f) <= 0.95f) {
                return;
            }
            MobEffectInstance siphonEffect = attacker.m_21124_((MobEffect)MorePotionEffectsModMobEffects.EFFECT_SIPHON.get());
            int effectLevel = siphonEffect.m_19564_() + 1;
            double stealChance = (Double)MPEconfigConfiguration.BASE_STEAL_CHANCE.get() + (double)effectLevel * 0.1;
            if ((double)attacker.m_217043_().m_188501_() >= stealChance) {
                return;
            }
            List<MobEffectInstance> stealableEffects = target.m_21220_().stream().filter(e -> e.m_19544_() != MorePotionEffectsModMobEffects.EFFECT_SIPHON.get()).toList();
            if (stealableEffects.isEmpty()) {
                return;
            }
            MobEffectInstance chosenEffect = stealableEffects.get(attacker.m_217043_().m_188503_(stealableEffects.size()));
            int stolenLevel = chosenEffect.m_19564_();
            int adjustedDuration = (int)((double)chosenEffect.m_19557_() * (1.0 - Math.pow((Double)MPEconfigConfiguration.DURATION_RATIO.get(), effectLevel)));
            attackerData.m_128379_("EffectSiphonProcessing", true);
            target.m_21195_(chosenEffect.m_19544_());
            attacker.m_7292_(new MobEffectInstance(chosenEffect.m_19544_(), adjustedDuration, Math.min(stolenLevel, effectLevel - 1), chosenEffect.m_19571_(), chosenEffect.m_19572_(), chosenEffect.m_19575_()));
            attackerData.m_128379_("EffectSiphonProcessing", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEffectAoe(LivingEntity attacker, LivingEntity target, DamageSource source, float damage) {
        MobEffectInstance aoeEffect = attacker.m_21124_((MobEffect)MorePotionEffectsModMobEffects.ATTACK_AOE.get());
        long aoeTime = attacker.m_9236_().m_46467_();
        CompoundTag attackerData = attacker.getPersistentData();
        if (aoeEffect == null) {
            return;
        }
        if (attackerData.m_128454_("AoeTime") == aoeTime) {
            MorePotionEffectsMod.queueServerWork(1, () -> attackerData.m_128473_("AoeTime"));
            return;
        }
        int amplifier = aoeEffect.m_19564_();
        double range = 1.0 + (double)amplifier * 0.5;
        List nearbyEntities = attacker.m_9236_().m_6443_(LivingEntity.class, target.m_20191_().m_82400_(range), entity -> entity != attacker && entity != target && entity.m_6084_());
        attackerData.m_128356_("AoeTime", aoeTime);
        for (LivingEntity entity2 : nearbyEntities) {
            if (entity2.getPersistentData().m_128441_("AttackAoeProcessing")) continue;
            entity2.getPersistentData().m_128379_("AttackAoeProcessing", true);
            try {
                float aoeDamage = damage * (float)amplifier * 0.25f;
                entity2.m_6469_(source, aoeDamage);
            }
            finally {
                entity2.getPersistentData().m_128473_("AttackAoeProcessing");
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHealed(@NotNull LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)MorePotionEffectsModMobEffects.STRONG_HEART.get())) {
            int vibrantLevel = entity.m_21124_((MobEffect)MorePotionEffectsModMobEffects.STRONG_HEART.get()).m_19564_() + 1;
            float originalAmount = event.getAmount();
            event.setAmount((float)((double)originalAmount * (1.0 + (double)vibrantLevel * 0.2)));
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingAttackEvent event) {
        LivingEntity target = event.getEntity();
        if (target.m_21023_((MobEffect)MorePotionEffectsModMobEffects.ADAPTATION.get())) {
            MobEffectInstance adaptationEffect = target.m_21124_((MobEffect)MorePotionEffectsModMobEffects.ADAPTATION.get());
            int amplifier = adaptationEffect.m_19564_();
            int requiredHurtTime = 10 - amplifier + 1;
            if (target.f_20916_ >= requiredHurtTime) {
                double currentDamage = event.getAmount();
                double lastDamage = target.getPersistentData().m_128459_("last_damage");
                boolean adaptDamageFlag = target.getPersistentData().m_128471_("adapt_damage");
                if (adaptDamageFlag && lastDamage >= currentDamage) {
                    event.setCanceled(true);
                } else {
                    target.getPersistentData().m_128347_("last_damage", currentDamage);
                }
                target.getPersistentData().m_128379_("adapt_damage", true);
            } else {
                target.getPersistentData().m_128379_("adapt_damage", false);
                target.getPersistentData().m_128347_("last_damage", 0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onUseItem(LivingEntityUseItemEvent.Tick event) {
        LivingEntity entity = event.getEntity();
        Item item = event.getItem().m_41720_();
        MPEEvent.handleQuickDraw(entity, item, event);
        MPEEvent.handleGluttony(entity, item, event);
    }

    private static void handleQuickDraw(LivingEntity entity, Item item, LivingEntityUseItemEvent.Tick event) {
        if (entity.m_21023_((MobEffect)MorePotionEffectsModMobEffects.QUICK_DRAW.get()) && item instanceof ProjectileWeaponItem) {
            MobEffectInstance effect = entity.m_21124_((MobEffect)MorePotionEffectsModMobEffects.QUICK_DRAW.get());
            int level = effect.m_19564_() + 1;
            CompoundTag tag = entity.getPersistentData();
            String key = "quickDrawCount";
            int counter = tag.m_128451_(key) + level;
            int reduceDuration = counter / 2;
            tag.m_128405_(key, counter % 2);
            int newDuration = Math.max(event.getDuration() - reduceDuration, 20);
            event.setDuration(newDuration);
        }
    }

    private static void handleGluttony(LivingEntity entity, Item item, LivingEntityUseItemEvent.Tick event) {
        if (entity.m_21023_((MobEffect)MorePotionEffectsModMobEffects.GLUTTONY.get())) {
            boolean isDrinkable;
            boolean isEdible = item.m_41472_();
            boolean bl = isDrinkable = item instanceof PotionItem || item instanceof HoneyBottleItem || item instanceof MilkBucketItem;
            if (isEdible || isDrinkable) {
                MobEffectInstance effect = entity.m_21124_((MobEffect)MorePotionEffectsModMobEffects.GLUTTONY.get());
                int level = effect.m_19564_() + 1;
                int acceleration = level + 1;
                int newDuration = Math.max(event.getDuration() - acceleration, 0);
                event.setDuration(newDuration);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)MorePotionEffectsModMobEffects.ENHANCE_DIGGING.get())) {
            int amplifier = player.m_21124_((MobEffect)MorePotionEffectsModMobEffects.ENHANCE_DIGGING.get()).m_19564_();
            float speedMultiplier = 1.0f + (float)(amplifier + 1) * 0.25f;
            event.setNewSpeed(event.getOriginalSpeed() * speedMultiplier);
        }
    }

    @SubscribeEvent
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        Player player = event.getEntity();
        BlockState state = event.getTargetBlock();
        if (player.m_21023_((MobEffect)MorePotionEffectsModMobEffects.ENHANCE_DIGGING.get())) {
            int requiredLevel;
            Item tool = player.m_21205_().m_41720_();
            int level = player.m_21124_((MobEffect)MorePotionEffectsModMobEffects.ENHANCE_DIGGING.get()).m_19564_() + 1;
            int effectiveLevel = level + MPEEvent.getPlayerToolLevel(tool);
            if (effectiveLevel > (requiredLevel = MPEEvent.getRequiredLevel(state)) && requiredLevel < 1 || MPEEvent.isRightTool(state, tool)) {
                event.setCanHarvest(true);
            }
        }
    }

    private static int getPlayerToolLevel(Item tool) {
        if (tool instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)tool;
            Tiers tier = (Tiers)tieredItem.m_43314_();
            return tier.m_6604_();
        }
        return 0;
    }

    private static int getRequiredLevel(BlockState state) {
        if (state.m_204336_(BlockTags.f_144284_)) {
            return 3;
        }
        if (state.m_204336_(BlockTags.f_144285_)) {
            return 2;
        }
        if (state.m_204336_(BlockTags.f_144286_)) {
            return 1;
        }
        return 0;
    }

    private static boolean isRightTool(BlockState state, Item tool) {
        if (state.m_60834_()) {
            if (state.m_204336_(BlockTags.f_144282_)) {
                return tool instanceof PickaxeItem;
            }
            if (state.m_204336_(BlockTags.f_144280_)) {
                return tool instanceof AxeItem;
            }
            if (state.m_204336_(BlockTags.f_144281_)) {
                return tool instanceof HoeItem;
            }
            if (state.m_204336_(BlockTags.f_144283_)) {
                return tool instanceof ShovelItem;
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof AreaEffectCloud)) {
            return;
        }
        AreaEffectCloud cloud = (AreaEffectCloud)entity;
        ArrayList effects = new ArrayList(cloud.m_146791_().m_43488_());
        int color = cloud.m_19744_();
        boolean hasRandomEffect = false;
        ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance originalEffect : effects) {
            MobEffect effectType = originalEffect.m_19544_();
            Supplier<MobEffect> supplier = null;
            if (effectType == MorePotionEffectsModMobEffects.RANDOM_POSITIVE_EFFECT.get()) {
                supplier = EffectUtils::getRandomGoodEffect;
            } else if (effectType == MorePotionEffectsModMobEffects.RANDOM_NEGATIVE_EFFECT.get()) {
                supplier = EffectUtils::getRandomBadEffect;
            } else if (effectType == MorePotionEffectsModMobEffects.RANDOM_EFFECT.get()) {
                supplier = EffectUtils::getRandomAllEffect;
            }
            if (supplier != null) {
                hasRandomEffect = true;
                MobEffect randomEffect = supplier.get();
                newEffects.add(new MobEffectInstance(randomEffect, originalEffect.m_19557_(), originalEffect.m_19564_(), originalEffect.m_19571_(), originalEffect.m_19572_()));
                continue;
            }
            newEffects.add(originalEffect);
        }
        if (hasRandomEffect) {
            MobEffectInstance[] effectArray = newEffects.toArray(new MobEffectInstance[0]);
            cloud.m_19722_(new Potion(effectArray));
            cloud.m_19714_(color);
        }
    }
}

